/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util;

import java.util.ArrayList;
import org.andengine.util.adt.array.ArrayUtils;
import org.andengine.util.math.MathUtils;

public class ProbabilityGenerator<T> {
    private float mProbabilitySum;
    private final ArrayList<Entry<T>> mEntries = new ArrayList();

    public void add(float pFactor, T ... pElements) {
        this.mProbabilitySum += pFactor;
        this.mEntries.add(new Entry<T>(pFactor, pElements));
    }

    public T next() {
        float random = MathUtils.random(0.0f, this.mProbabilitySum);
        ArrayList<Entry<T>> factors = this.mEntries;
        for (int i = factors.size() - 1; i >= 0; --i) {
            Entry<T> entry = factors.get(i);
            if (!((random -= entry.mFactor) <= 0.0f)) continue;
            return entry.getReturnValue();
        }
        Entry<T> lastEntry = factors.get(factors.size() - 1);
        return lastEntry.getReturnValue();
    }

    public void clear() {
        this.mProbabilitySum = 0.0f;
        this.mEntries.clear();
    }

    private static class Entry<T> {
        public final float mFactor;
        public final T[] mData;

        public Entry(float pFactor, T ... pData) {
            this.mFactor = pFactor;
            this.mData = pData;
        }

        public T getReturnValue() {
            if (this.mData.length == 1) {
                return this.mData[0];
            }
            return ArrayUtils.random(this.mData);
        }
    }
}

