/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;

public final class StreamUtils {
    public static final int IO_BUFFER_SIZE = 8192;
    private static final int END_OF_STREAM = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readFully(InputStream pInputStream) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buf = new char[8192];
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader(pInputStream, "UTF-8"));
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
        finally {
            StreamUtils.close(pInputStream);
        }
        return writer.toString();
    }

    public static final byte[] streamToBytes(InputStream pInputStream) throws IOException {
        return StreamUtils.streamToBytes(pInputStream, -1);
    }

    public static final byte[] streamToBytes(InputStream pInputStream, int pReadLimit) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(pReadLimit == -1 ? 8192 : pReadLimit);
        StreamUtils.copy(pInputStream, os, pReadLimit);
        return os.toByteArray();
    }

    public static final void streamToBytes(InputStream pInputStream, int pByteLimit, byte[] pData) throws IOException {
        StreamUtils.streamToBytes(pInputStream, pByteLimit, pData, 0);
    }

    public static final void streamToBytes(InputStream pInputStream, int pByteLimit, byte[] pData, int pOffset) throws IOException {
        int read;
        if (pByteLimit > pData.length - pOffset) {
            throw new IOException("pData is not big enough.");
        }
        int pBytesLeftToRead = pByteLimit;
        int readTotal = 0;
        while ((read = pInputStream.read(pData, pOffset + readTotal, pBytesLeftToRead)) != -1) {
            readTotal += read;
            if (pBytesLeftToRead <= read) break;
            pBytesLeftToRead -= read;
        }
        if (readTotal != pByteLimit) {
            throw new IOException("ReadLimit: '" + pByteLimit + "', Read: '" + readTotal + "'.");
        }
    }

    public static final void copy(InputStream pInputStream, OutputStream pOutputStream) throws IOException {
        StreamUtils.copy(pInputStream, pOutputStream, -1);
    }

    public static final void copy(InputStream pInputStream, byte[] pData) throws IOException {
        int read;
        int dataOffset = 0;
        byte[] buf = new byte[8192];
        while ((read = pInputStream.read(buf)) != -1) {
            System.arraycopy(buf, 0, pData, dataOffset, read);
            dataOffset += read;
        }
    }

    public static final void copy(InputStream pInputStream, ByteBuffer pByteBuffer) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        while ((read = pInputStream.read(buf)) != -1) {
            pByteBuffer.put(buf, 0, read);
        }
    }

    public static final void copy(InputStream pInputStream, OutputStream pOutputStream, int pByteLimit) throws IOException {
        if (pByteLimit == -1) {
            int read;
            byte[] buf = new byte[8192];
            while ((read = pInputStream.read(buf)) != -1) {
                pOutputStream.write(buf, 0, read);
            }
        } else {
            int read;
            byte[] buf = new byte[8192];
            int bufferReadLimit = Math.min(pByteLimit, 8192);
            long pBytesLeftToRead = pByteLimit;
            while ((read = pInputStream.read(buf, 0, bufferReadLimit)) != -1) {
                if (pBytesLeftToRead > (long)read) {
                    pOutputStream.write(buf, 0, read);
                    pBytesLeftToRead -= (long)read;
                    continue;
                }
                pOutputStream.write(buf, 0, (int)pBytesLeftToRead);
                break;
            }
        }
        pOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean copyAndClose(InputStream pInputStream, OutputStream pOutputStream) {
        try {
            StreamUtils.copy(pInputStream, pOutputStream, -1);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.close(pInputStream);
            StreamUtils.close(pOutputStream);
        }
    }

    public static final void close(Closeable pCloseable) {
        if (pCloseable != null) {
            try {
                pCloseable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void flushCloseStream(OutputStream pOutputStream) {
        if (pOutputStream != null) {
            try {
                pOutputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                StreamUtils.close(pOutputStream);
            }
        }
    }

    public static final void flushCloseWriter(Writer pWriter) {
        if (pWriter != null) {
            try {
                pWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                StreamUtils.close(pWriter);
            }
        }
    }
}

