/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.bit;

public final class BitVector {
    private final int mCapacity;
    private final long[] mData;

    private BitVector(int pCapacity) {
        if (pCapacity <= 0) {
            throw new IllegalArgumentException("pCapacity must be > 0.");
        }
        this.mCapacity = pCapacity;
        boolean perfectDataFit = pCapacity % 64 == 0;
        int dataCapacity = perfectDataFit ? pCapacity / 64 : pCapacity / 64 + 1;
        this.mData = new long[dataCapacity];
    }

    public BitVector(byte[] pBytes) {
        this(pBytes.length * 8);
        int lastCompleteDataIndex;
        long[] data = this.mData;
        boolean perfectDataFit = pBytes.length % 8 == 0;
        int dataCapacity = data.length;
        for (int i = lastCompleteDataIndex = perfectDataFit ? dataCapacity - 1 : dataCapacity - 2; i >= 0; --i) {
            int bytesOffset = i * 8;
            data[i] = (long)pBytes[bytesOffset + 0] << 56 & 0xFF00000000000000L | (long)pBytes[bytesOffset + 1] << 48 & 0xFF000000000000L | (long)pBytes[bytesOffset + 2] << 40 & 0xFF0000000000L | (long)pBytes[bytesOffset + 3] << 32 & 0xFF00000000L | (long)pBytes[bytesOffset + 4] << 24 & 0xFF000000L | (long)pBytes[bytesOffset + 5] << 16 & 0xFF0000L | (long)pBytes[bytesOffset + 6] << 8 & 0xFF00L | (long)pBytes[bytesOffset + 7] << 0 & 0xFFL;
        }
        if (!perfectDataFit) {
            long overflowData = 0L;
            int overflowDataIndex = dataCapacity - 1;
            int overflowBytesOffset = overflowDataIndex * 8;
            int overflowByteCount = pBytes.length - overflowBytesOffset;
            switch (overflowByteCount) {
                case 7: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 6] << 8 & 0xFF00L;
                }
                case 6: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 5] << 16 & 0xFF0000L;
                }
                case 5: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 4] << 24 & 0xFF000000L;
                }
                case 4: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 3] << 32 & 0xFF00000000L;
                }
                case 3: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 2] << 40 & 0xFF0000000000L;
                }
                case 2: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 1] << 48 & 0xFF000000000000L;
                }
                case 1: {
                    overflowData |= (long)pBytes[overflowBytesOffset + 0] << 56 & 0xFF00000000000000L;
                }
            }
            data[overflowDataIndex] = overflowData;
        }
    }

    public int getCapacity() {
        return this.mCapacity;
    }

    public boolean getBit(int pPosition) {
        if (pPosition < 0) {
            throw new IllegalArgumentException("pPosition must be >= 0.");
        }
        if (pPosition >= this.mCapacity) {
            throw new IllegalArgumentException("pPosition must be < capacity.");
        }
        int dataIndex = pPosition / 64;
        long dataField = this.mData[dataIndex];
        int dataOffset = pPosition % 64;
        int rightShift = 64 - dataOffset - 1;
        long bit = dataField >> rightShift & 1L;
        return bit != 0L;
    }

    public byte getByte(int pPosition) {
        return (byte)this.getBits(pPosition, 8);
    }

    public short getShort(int pPosition) {
        return (short)this.getBits(pPosition, 16);
    }

    public int getInt(int pPosition) {
        return (int)this.getBits(pPosition, 32);
    }

    public long getLong(int pPosition) {
        return this.getBits(pPosition, 64);
    }

    public long getBits(int pPosition, int pLength) {
        if (pPosition < 0) {
            throw new IllegalArgumentException("pPosition must be >= 0.");
        }
        if (pLength < 0) {
            throw new IllegalArgumentException("pLength must be >= 0.");
        }
        if (pPosition + pLength > this.mCapacity) {
            throw new IllegalArgumentException("pPosition + pLength must be <= capacity.");
        }
        if (pLength == 0) {
            return 0L;
        }
        int dataIndex = pPosition / 64;
        int offset = pPosition % 64;
        long data = offset == 0 ? this.mData[dataIndex] : (offset + pLength <= 64 ? this.mData[dataIndex] << offset : this.mData[dataIndex] << offset | this.mData[dataIndex + 1] >>> 64 - offset);
        if (pLength == 64) {
            return data;
        }
        int rightShift = 64 - pLength;
        long mask = -1L >>> rightShift;
        long unmaskedBits = data >> rightShift;
        return unmaskedBits & mask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.mCapacity; ++i) {
            sb.append(this.getBit(i) ? (char)'1' : '0');
            if (i % 8 != 7 || i >= this.mCapacity - 1) continue;
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    public byte[] toByteArray() {
        int byteArrayLength = this.mCapacity % 8 == 0 ? this.mCapacity / 8 : this.mCapacity / 8 + 1;
        byte[] bytes = new byte[byteArrayLength];
        boolean perfectDataFit = this.mCapacity % 64 == 0;
        long[] data = this.mData;
        int dataCapacity = data.length;
        int lastCompleteDataIndex = perfectDataFit ? dataCapacity - 1 : dataCapacity - 2;
        int bytesOffset = lastCompleteDataIndex * 8 + 7;
        for (int i = lastCompleteDataIndex; i >= 0; --i) {
            long dataField = data[i];
            bytes[bytesOffset--] = (byte)(dataField >> 0 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 8 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 16 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 24 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 32 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 40 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 48 & 0xFFL);
            bytes[bytesOffset--] = (byte)(dataField >> 56 & 0xFFL);
        }
        if (!perfectDataFit) {
            int overflowDataIndex = dataCapacity - 1;
            long overflowDataField = data[overflowDataIndex];
            int overflowBytesOffset = overflowDataIndex * 8;
            int overflowByteCount = bytes.length % 8;
            switch (overflowByteCount) {
                case 7: {
                    bytes[overflowBytesOffset + 6] = (byte)(overflowDataField >> 8 & 0xFFL);
                }
                case 6: {
                    bytes[overflowBytesOffset + 5] = (byte)(overflowDataField >> 16 & 0xFFL);
                }
                case 5: {
                    bytes[overflowBytesOffset + 4] = (byte)(overflowDataField >> 24 & 0xFFL);
                }
                case 4: {
                    bytes[overflowBytesOffset + 3] = (byte)(overflowDataField >> 32 & 0xFFL);
                }
                case 3: {
                    bytes[overflowBytesOffset + 2] = (byte)(overflowDataField >> 40 & 0xFFL);
                }
                case 2: {
                    bytes[overflowBytesOffset + 1] = (byte)(overflowDataField >> 48 & 0xFFL);
                }
                case 1: {
                    bytes[overflowBytesOffset + 0] = (byte)(overflowDataField >> 56 & 0xFFL);
                }
            }
        }
        return bytes;
    }
}

