/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.bounds;

import org.andengine.util.adt.bounds.IFloatBounds;
import org.andengine.util.adt.spatial.bounds.util.FloatBoundsUtils;

public class FloatBounds
implements IFloatBounds {
    private float mXMin;
    private float mYMin;
    private float mXMax;
    private float mYMax;

    public FloatBounds(float pX, float pY) {
        this.set(pX, pY);
    }

    public FloatBounds(float pXMin, float pYMin, float pXMax, float pYMax) {
        this.set(pXMin, pYMin, pXMax, pYMax);
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    public void set(float pX, float pY) {
        this.set(pX, pY, pX, pY);
    }

    public void set(float pXMin, float pYMin, float pXMax, float pYMax) {
        this.mXMin = pXMin;
        this.mYMin = pYMin;
        this.mXMax = pXMax;
        this.mYMax = pYMax;
        if (pXMin > pXMax) {
            throw new IllegalArgumentException("pXMin: '" + pXMin + "' must be smaller or equal to pXMax: '" + pXMax + "'.");
        }
        if (pYMin > pYMax) {
            throw new IllegalArgumentException("pYMin: '" + pYMin + "' must be smaller or equal to pYMax: '" + pYMax + "'.");
        }
    }

    public boolean contains(float pX, float pY) {
        return FloatBoundsUtils.contains(this.mXMin, this.mYMin, this.mXMax, this.mYMax, pX, pY);
    }
}

