/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.cache;

import java.util.HashMap;
import org.andengine.util.adt.pool.GenericPool;

public class LRUCache<K, V> {
    private final int mCapacity;
    private int mSize;
    private final HashMap<K, LRUCacheValueHolder<K, V>> mMap;
    private final LRUCacheQueue<K> mLRUCacheQueue;
    private final GenericPool<LRUCacheValueHolder<K, V>> mLRUCacheValueHolderPool = new GenericPool<LRUCacheValueHolder<K, V>>(){

        @Override
        protected LRUCacheValueHolder<K, V> onAllocatePoolItem() {
            return new LRUCacheValueHolder();
        }

        @Override
        protected void onHandleRecycleItem(LRUCacheValueHolder<K, V> pLRUCacheValueHolder) {
            pLRUCacheValueHolder.mLRUCacheQueueNode = null;
            pLRUCacheValueHolder.mValue = null;
        }
    };

    public LRUCache(int pCapacity) {
        this.mCapacity = pCapacity;
        this.mMap = new HashMap(pCapacity);
        this.mLRUCacheQueue = new LRUCacheQueue();
    }

    public int getCapacity() {
        return this.mCapacity;
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public V put(K pKey, V pValue) {
        LRUCacheValueHolder<K, V> existingLRUCacheValueHolder = this.mMap.get(pKey);
        if (existingLRUCacheValueHolder != null) {
            this.mLRUCacheQueue.moveToTail(existingLRUCacheValueHolder.mLRUCacheQueueNode);
            return existingLRUCacheValueHolder.mValue;
        }
        if (this.mSize >= this.mCapacity) {
            K deadKey = this.mLRUCacheQueue.poll();
            this.mMap.remove(deadKey);
            --this.mSize;
        }
        LRUCacheQueueNode<K> lruCacheQueueNode = this.mLRUCacheQueue.add(pKey);
        LRUCacheValueHolder<K, V> lruCacheValueHolder = this.mLRUCacheValueHolderPool.obtainPoolItem();
        lruCacheValueHolder.mValue = pValue;
        lruCacheValueHolder.mLRUCacheQueueNode = lruCacheQueueNode;
        this.mMap.put(pKey, lruCacheValueHolder);
        ++this.mSize;
        return null;
    }

    public V get(K pKey) {
        LRUCacheValueHolder<K, V> lruCacheValueHolder = this.mMap.get(pKey);
        if (lruCacheValueHolder == null) {
            return null;
        }
        this.mLRUCacheQueue.moveToTail(lruCacheValueHolder.mLRUCacheQueueNode);
        return lruCacheValueHolder.mValue;
    }

    public void clear() {
        while (!this.mLRUCacheQueue.isEmpty()) {
            K key = this.mLRUCacheQueue.poll();
            LRUCacheValueHolder<K, V> lruCacheValueHolder = this.mMap.remove(key);
            this.mLRUCacheValueHolderPool.recyclePoolItem(lruCacheValueHolder);
        }
        this.mSize = 0;
    }

    static class LRUCacheQueue<K> {
        private LRUCacheQueueNode<K> mHead;
        private LRUCacheQueueNode<K> mTail;
        private final GenericPool<LRUCacheQueueNode<K>> mLRUCacheQueueNodePool = new GenericPool<LRUCacheQueueNode<K>>(){

            @Override
            protected LRUCacheQueueNode<K> onAllocatePoolItem() {
                return new LRUCacheQueueNode();
            }

            @Override
            protected void onHandleRecycleItem(LRUCacheQueueNode<K> pLRUCacheQueueNode) {
                pLRUCacheQueueNode.mKey = null;
                pLRUCacheQueueNode.mPrevious = null;
                pLRUCacheQueueNode.mNext = null;
            }
        };

        LRUCacheQueue() {
        }

        public boolean isEmpty() {
            return this.mHead == null;
        }

        public LRUCacheQueueNode<K> add(K pKey) {
            LRUCacheQueueNode<K> lruCacheQueueNode = this.mLRUCacheQueueNodePool.obtainPoolItem();
            lruCacheQueueNode.mKey = pKey;
            return this.add(lruCacheQueueNode);
        }

        private LRUCacheQueueNode<K> add(LRUCacheQueueNode<K> pLRUCacheQueueNode) {
            if (this.isEmpty()) {
                this.mHead = pLRUCacheQueueNode;
                this.mTail = this.mHead;
            } else {
                this.mTail.mNext = pLRUCacheQueueNode;
                pLRUCacheQueueNode.mPrevious = this.mTail;
                this.mTail = pLRUCacheQueueNode;
            }
            return this.mTail;
        }

        public K poll() {
            LRUCacheQueueNode<K> head = this.mHead;
            Object key = this.mHead.mKey;
            if (this.mHead.mNext == null) {
                this.mHead = null;
                this.mTail = null;
            } else {
                this.mHead = this.mHead.mNext;
                this.mHead.mPrevious = null;
            }
            this.mLRUCacheQueueNodePool.recyclePoolItem(head);
            return key;
        }

        public void moveToTail(LRUCacheQueueNode<K> pLRUCacheQueueNode) {
            LRUCacheQueueNode previous;
            LRUCacheQueueNode next = pLRUCacheQueueNode.mNext;
            if (next == null) {
                return;
            }
            next.mPrevious = previous = pLRUCacheQueueNode.mPrevious;
            if (previous == null) {
                this.mHead = next;
            } else {
                previous.mNext = next;
            }
            this.mTail.mNext = pLRUCacheQueueNode;
            pLRUCacheQueueNode.mPrevious = this.mTail;
            pLRUCacheQueueNode.mNext = null;
            this.mTail = pLRUCacheQueueNode;
        }
    }

    static class LRUCacheValueHolder<K, V> {
        V mValue;
        LRUCacheQueueNode<K> mLRUCacheQueueNode;

        LRUCacheValueHolder() {
        }
    }

    static class LRUCacheQueueNode<K> {
        K mKey;
        LRUCacheQueueNode<K> mPrevious;
        LRUCacheQueueNode<K> mNext;

        LRUCacheQueueNode() {
        }
    }
}

