/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import java.util.Arrays;
import org.andengine.util.adt.list.IList;

public class CircularList<T>
implements IList<T> {
    private static final int CAPACITY_INITIAL_DEFAULT = 1;
    private static final int INDEX_INVALID = -1;
    private Object[] mItems;
    private int mHead;
    private int mSize;

    public CircularList() {
        this(1);
    }

    public CircularList(int pInitialCapacity) {
        this.mItems = new Object[pInitialCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public void add(T pItem) {
        this.ensureCapacity();
        this.mItems[this.encodeToInternalIndex((int)this.mSize)] = pItem;
        ++this.mSize;
    }

    @Override
    public T get(int pIndex) throws ArrayIndexOutOfBoundsException {
        return (T)this.mItems[this.encodeToInternalIndex(pIndex)];
    }

    @Override
    public void set(int pIndex, T pItem) throws IndexOutOfBoundsException {
        this.mItems[this.encodeToInternalIndex((int)pIndex)] = pItem;
    }

    @Override
    public int indexOf(T pItem) {
        int size = this.size();
        if (pItem == null) {
            for (int i = 0; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!pItem.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void add(int pIndex, T pItem) {
        int internalIndex = this.encodeToInternalIndex(pIndex);
        this.ensureCapacity();
        int internalTail = this.encodeToInternalIndex(this.mSize);
        if (internalIndex != internalTail) {
            if (internalIndex == this.mHead) {
                --this.mHead;
                if (this.mHead == -1) {
                    this.mHead = this.mItems.length - 1;
                }
                if (--internalIndex == -1) {
                    internalIndex = this.mItems.length - 1;
                }
            } else if (internalIndex < this.mHead || this.mHead == 0) {
                System.arraycopy(this.mItems, internalIndex, this.mItems, internalIndex + 1, internalTail - internalIndex);
            } else if (internalIndex > internalTail) {
                System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead - 1, pIndex);
                --this.mHead;
                if (this.mHead == -1) {
                    this.mHead = this.mItems.length - 1;
                }
                if (--internalIndex == -1) {
                    internalIndex = this.mItems.length - 1;
                }
            } else if (pIndex < this.mSize >> 1) {
                System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead - 1, pIndex);
                --this.mHead;
                if (this.mHead == -1) {
                    this.mHead = this.mItems.length - 1;
                }
                if (--internalIndex == -1) {
                    internalIndex = this.mItems.length - 1;
                }
            } else {
                System.arraycopy(this.mItems, internalIndex, this.mItems, internalIndex + 1, internalTail - internalIndex);
            }
        }
        this.mItems[internalIndex] = pItem;
        ++this.mSize;
    }

    @Override
    public T removeFirst() {
        return this.remove(0);
    }

    @Override
    public T removeLast() {
        return this.remove(this.size() - 1);
    }

    @Override
    public boolean remove(T pItem) {
        int index = this.indexOf(pItem);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public T remove(int pIndex) {
        int internalIndex = this.encodeToInternalIndex(pIndex);
        Object removed = this.mItems[internalIndex];
        int internalTail = this.encodeToInternalIndex(this.mSize - 1);
        if (internalIndex == internalTail) {
            this.mItems[internalTail] = null;
        } else if (internalIndex == this.mHead) {
            this.mItems[this.mHead] = null;
            ++this.mHead;
            if (this.mHead == this.mItems.length) {
                this.mHead = 0;
            }
        } else if (internalIndex < this.mHead) {
            System.arraycopy(this.mItems, internalIndex + 1, this.mItems, internalIndex, internalTail - internalIndex);
            this.mItems[internalTail] = null;
        } else if (internalIndex > internalTail) {
            System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead + 1, pIndex);
            this.mItems[this.mHead] = null;
            ++this.mHead;
            if (this.mHead == this.mItems.length) {
                this.mHead = 0;
            }
        } else if (pIndex < this.mSize >> 1) {
            System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead + 1, pIndex);
            this.mItems[this.mHead] = null;
            ++this.mHead;
            if (this.mHead == this.mItems.length) {
                this.mHead = 0;
            }
        } else {
            System.arraycopy(this.mItems, internalIndex + 1, this.mItems, internalIndex, internalTail - internalIndex);
            this.mItems[internalTail] = null;
        }
        --this.mSize;
        return (T)removed;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        int tail = this.mHead + this.mSize;
        int capacity = this.mItems.length;
        if (tail <= capacity) {
            Arrays.fill(this.mItems, this.mHead, tail, null);
        } else {
            int headToCapacity = capacity - this.mHead;
            Arrays.fill(this.mItems, this.mHead, capacity, null);
            Arrays.fill(this.mItems, 0, this.mSize - headToCapacity, null);
        }
        this.mHead = 0;
        this.mSize = 0;
    }

    private void ensureCapacity() {
        int currentCapacity = this.mItems.length;
        if (this.mSize == currentCapacity) {
            int newCapacity = (currentCapacity * 3 >> 1) + 1;
            Object[] newItems = new Object[newCapacity];
            System.arraycopy(this.mItems, this.mHead, newItems, 0, this.mSize - this.mHead);
            System.arraycopy(this.mItems, 0, newItems, this.mSize - this.mHead, this.mHead);
            this.mItems = newItems;
            this.mHead = 0;
        }
    }

    private int encodeToInternalIndex(int pIndex) {
        int internalIndex = this.mHead + pIndex;
        if (internalIndex >= this.mItems.length) {
            internalIndex -= this.mItems.length;
        }
        return internalIndex;
    }
}

