/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import org.andengine.util.adt.list.IFloatList;

public class FloatArrayList
implements IFloatList {
    private static final int CAPACITY_INITIAL_DEFAULT = 0;
    private float[] mItems;
    private int mSize;

    public FloatArrayList() {
        this(0);
    }

    public FloatArrayList(int pInitialCapacity) {
        this.mItems = new float[pInitialCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public float get(int pIndex) throws ArrayIndexOutOfBoundsException {
        return this.mItems[pIndex];
    }

    @Override
    public void add(float pItem) {
        this.ensureCapacity(this.mSize + 1);
        this.mItems[this.mSize] = pItem;
        ++this.mSize;
    }

    @Override
    public void add(int pIndex, float pItem) throws ArrayIndexOutOfBoundsException {
        this.ensureCapacity(this.mSize + 1);
        System.arraycopy(this.mItems, pIndex, this.mItems, pIndex + 1, this.mSize - pIndex);
        this.mItems[pIndex] = pItem;
        ++this.mSize;
    }

    @Override
    public float remove(int pIndex) throws ArrayIndexOutOfBoundsException {
        float oldValue = this.mItems[pIndex];
        int numMoved = this.mSize - pIndex - 1;
        if (numMoved > 0) {
            System.arraycopy(this.mItems, pIndex + 1, this.mItems, pIndex, numMoved);
        }
        --this.mSize;
        return oldValue;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        this.mSize = 0;
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.mSize];
        System.arraycopy(this.mItems, 0, array, 0, this.mSize);
        return array;
    }

    private void ensureCapacity(int pCapacity) {
        int currentCapacity = this.mItems.length;
        if (currentCapacity < pCapacity) {
            int newCapacity = (currentCapacity * 3 >> 1) + 1;
            float[] newItems = new float[newCapacity];
            System.arraycopy(this.mItems, 0, newItems, 0, currentCapacity);
            this.mItems = newItems;
        }
    }
}

