/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import java.util.Arrays;
import org.andengine.util.adt.queue.IQueue;

public class ShiftList<T>
implements IQueue<T> {
    private static final int CAPACITY_INITIAL_DEFAULT = 1;
    private static final int INDEX_INVALID = -1;
    protected Object[] mItems;
    protected int mHead;
    protected int mTail;

    public ShiftList() {
        this(1);
    }

    public ShiftList(int pInitialCapacity) {
        this.mItems = new Object[pInitialCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.mHead == this.mTail;
    }

    @Override
    public T get(int pIndex) throws ArrayIndexOutOfBoundsException {
        return (T)this.mItems[this.mHead + pIndex];
    }

    @Override
    public void set(int pIndex, T pItem) throws IndexOutOfBoundsException {
        this.mItems[this.mHead + pIndex] = pItem;
    }

    @Override
    public int indexOf(T pItem) {
        if (pItem == null) {
            for (int i = this.mHead; i < this.mTail; ++i) {
                if (this.mItems[i] != null) continue;
                return i - this.mHead;
            }
        } else {
            for (int i = this.mHead; i < this.mTail; ++i) {
                if (!pItem.equals(this.mItems[i])) continue;
                return i - this.mHead;
            }
        }
        return -1;
    }

    @Override
    public T peek() {
        if (this.mHead == this.mTail) {
            return null;
        }
        return (T)this.mItems[this.mHead];
    }

    @Override
    public T poll() {
        if (this.mHead == this.mTail) {
            return null;
        }
        Object item = this.mItems[this.mHead];
        this.mItems[this.mHead] = null;
        ++this.mHead;
        if (this.mHead == this.mTail) {
            this.mHead = 0;
            this.mTail = 0;
        }
        return (T)item;
    }

    @Override
    public void enter(T pItem) {
        this.ensureShiftableRight();
        this.mItems[this.mTail] = pItem;
        ++this.mTail;
    }

    @Override
    public void enter(int pIndex, T pItem) throws ArrayIndexOutOfBoundsException {
        int size = this.mTail - this.mHead;
        if (pIndex < size >> 1) {
            this.enterShiftingLeft(pIndex, pItem);
        } else {
            this.enterShiftingRight(pIndex, pItem, size);
        }
    }

    private void enterShiftingRight(int pIndex, T pItem, int size) {
        this.ensureShiftableRight();
        int shiftAmount = size - pIndex;
        if (shiftAmount == 0) {
            this.mItems[this.mTail] = pItem;
        } else {
            int internalIndex = this.mHead + pIndex;
            System.arraycopy(this.mItems, internalIndex, this.mItems, internalIndex + 1, shiftAmount);
            this.mItems[internalIndex] = pItem;
        }
        ++this.mTail;
    }

    private void enterShiftingLeft(int pIndex, T pItem) {
        this.ensureShiftableLeft();
        --this.mHead;
        if (pIndex == 0) {
            this.mItems[this.mHead] = pItem;
        } else {
            System.arraycopy(this.mItems, this.mHead + 1, this.mItems, this.mHead, pIndex);
            int internalIndex = this.mHead + pIndex;
            this.mItems[internalIndex] = pItem;
        }
    }

    @Override
    public void add(T pItem) {
        this.enter(pItem);
    }

    @Override
    public void add(int pIndex, T pItem) throws ArrayIndexOutOfBoundsException {
        this.enter(pIndex, pItem);
    }

    @Override
    public T removeFirst() {
        return this.remove(0);
    }

    @Override
    public T removeLast() {
        return this.remove(this.size() - 1);
    }

    @Override
    public boolean remove(T pItem) {
        int index = this.indexOf(pItem);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public T remove(int pIndex) throws ArrayIndexOutOfBoundsException {
        int internalIndex = this.mHead + pIndex;
        Object removed = this.mItems[internalIndex];
        int size = this.mTail - this.mHead;
        int center = size >> 1;
        if (pIndex < center) {
            if (internalIndex > this.mHead) {
                System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead + 1, pIndex);
            }
            this.mItems[this.mHead] = null;
            ++this.mHead;
        } else {
            int shiftAmount = size - pIndex - 1;
            if (shiftAmount > 0) {
                System.arraycopy(this.mItems, internalIndex + 1, this.mItems, internalIndex, shiftAmount);
            }
            --this.mTail;
            this.mItems[this.mTail] = null;
        }
        return (T)removed;
    }

    @Override
    public int size() {
        return this.mTail - this.mHead;
    }

    @Override
    public void clear() {
        Arrays.fill(this.mItems, this.mHead, this.mTail, null);
        this.mHead = 0;
        this.mTail = 0;
    }

    public void shift() {
        int size = this.mTail - this.mHead;
        if (size == 0) {
            this.mHead = 0;
            this.mTail = 0;
        } else {
            System.arraycopy(this.mItems, this.mHead, this.mItems, 0, size);
            int start = Math.max(size, this.mHead);
            int end = Math.max(start, this.mTail);
            if (start < end) {
                Arrays.fill(this.mItems, start, end, null);
            }
            this.mHead = 0;
            this.mTail = size;
        }
    }

    private void ensureShiftableRight() {
        int currentCapacity = this.mItems.length;
        if (this.mTail == currentCapacity) {
            int size = this.mTail - this.mHead;
            if (size != currentCapacity) {
                this.shift();
            } else {
                int newCapacity = (currentCapacity * 3 >> 1) + 1;
                Object[] newItems = new Object[newCapacity];
                System.arraycopy(this.mItems, 0, newItems, 0, currentCapacity);
                this.mItems = newItems;
            }
        }
    }

    private void ensureShiftableLeft() {
        if (this.mHead == 0) {
            int size = this.mTail - this.mHead;
            int currentCapacity = this.mItems.length;
            if (size < currentCapacity) {
                if (size == 0) {
                    this.mHead = 1;
                    this.mTail = 1;
                } else {
                    System.arraycopy(this.mItems, this.mHead, this.mItems, this.mHead + 1, size);
                    this.mItems[this.mHead] = null;
                    ++this.mHead;
                    ++this.mTail;
                }
            } else {
                int newCapacity = (currentCapacity * 3 >> 1) + 1;
                Object[] newItems = new Object[newCapacity];
                System.arraycopy(this.mItems, 0, newItems, 1, currentCapacity);
                this.mItems = newItems;
                ++this.mHead;
                ++this.mTail;
            }
        }
    }
}

