/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import java.util.ArrayList;
import java.util.List;
import org.andengine.util.IMatcher;
import org.andengine.util.call.ParameterCallable;

public class SmartList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 8655669528273139819L;

    public SmartList() {
    }

    public SmartList(int pCapacity) {
        super(pCapacity);
    }

    @Override
    public void addFirst(T pItem) {
        this.add(0, pItem);
    }

    @Override
    public void addLast(T pItem) {
        this.add(this.size(), pItem);
    }

    @Override
    public T getFirst() throws IndexOutOfBoundsException {
        return (T)this.get(0);
    }

    @Override
    public T getLast() throws IndexOutOfBoundsException {
        return (T)this.get(this.size() - 1);
    }

    public T get(IMatcher<T> pMatcher) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            return (T)item;
        }
        return null;
    }

    @Override
    public T removeFirst() throws IndexOutOfBoundsException {
        return (T)this.remove(0);
    }

    @Override
    public T removeLast() throws IndexOutOfBoundsException {
        return (T)this.remove(this.size() - 1);
    }

    public boolean remove(T pItem, ParameterCallable<T> pParameterCallable) {
        boolean removed = this.remove(pItem);
        if (removed) {
            pParameterCallable.call(pItem);
        }
        return removed;
    }

    public T remove(IMatcher<T> pMatcher) {
        for (int i = 0; i < this.size(); ++i) {
            if (!pMatcher.matches(this.get(i))) continue;
            return (T)this.remove(i);
        }
        return null;
    }

    public T remove(IMatcher<T> pMatcher, ParameterCallable<T> pParameterCallable) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!pMatcher.matches(this.get(i))) continue;
            Object removed = this.remove(i);
            pParameterCallable.call(removed);
            return (T)removed;
        }
        return null;
    }

    @Override
    public boolean removeAll(IMatcher<T> pMatcher) {
        boolean result = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!pMatcher.matches(this.get(i))) continue;
            this.remove(i);
            result = true;
        }
        return result;
    }

    public boolean removeAll(IMatcher<T> pMatcher, ParameterCallable<T> pParameterCallable) {
        boolean result = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!pMatcher.matches(this.get(i))) continue;
            Object removed = this.remove(i);
            pParameterCallable.call(removed);
            result = true;
        }
        return result;
    }

    public void clear(ParameterCallable<T> pParameterCallable) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object removed = this.remove(i);
            pParameterCallable.call(removed);
        }
    }

    public int indexOf(IMatcher<T> pMatcher) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(IMatcher<T> pMatcher) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            return i;
        }
        return -1;
    }

    public ArrayList<T> query(IMatcher<T> pMatcher) {
        return this.query(pMatcher, new ArrayList());
    }

    public <L extends List<T>> L query(IMatcher<T> pMatcher, L pResult) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            pResult.add(item);
        }
        return pResult;
    }

    public <S extends T> ArrayList<S> queryForSubclass(IMatcher<T> pMatcher) {
        return this.queryForSubclass(pMatcher, new ArrayList());
    }

    public <L extends List<S>, S extends T> L queryForSubclass(IMatcher<T> pMatcher, L pResult) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            pResult.add(item);
        }
        return pResult;
    }

    public void call(ParameterCallable<T> pParameterCallable) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object item = this.get(i);
            pParameterCallable.call(item);
        }
    }

    public void call(IMatcher<T> pMatcher, ParameterCallable<T> pParameterCallable) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object item = this.get(i);
            if (!pMatcher.matches(item)) continue;
            pParameterCallable.call(item);
        }
    }
}

