/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import org.andengine.util.adt.list.IList;
import org.andengine.util.adt.list.ISortedList;
import org.andengine.util.adt.list.ListUtils;

public class SortedList<T extends Comparable<T>>
implements ISortedList<T> {
    private static final int INDEX_INVALID = -1;
    private final IList<T> mList;

    public SortedList(IList<T> pList) {
        this.mList = pList;
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    public T get(int pIndex) throws IndexOutOfBoundsException {
        return (T)((Comparable)this.mList.get(pIndex));
    }

    @Override
    @Deprecated
    public void set(int pIndex, T pItem) throws IndexOutOfBoundsException {
        this.mList.set(pIndex, pItem);
    }

    @Override
    public int indexOf(T pItem) {
        return this.binarySearch(pItem, false);
    }

    @Override
    @Deprecated
    public void add(int pIndex, T pItem) {
        this.mList.add(pItem);
    }

    @Override
    public void add(T pItem) {
        int index = this.binarySearch(pItem, true);
        if (index < 0) {
            this.mList.add(ListUtils.encodeInsertionIndex(index), pItem);
        } else {
            this.mList.add(index, pItem);
        }
    }

    @Override
    public T removeFirst() {
        return (T)((Comparable)this.mList.removeFirst());
    }

    @Override
    public T removeLast() {
        return (T)((Comparable)this.mList.removeLast());
    }

    @Override
    public boolean remove(T pItem) {
        if (pItem == null) {
            return this.mList.remove(pItem);
        }
        int index = this.binarySearch(pItem, false);
        if (index >= 0) {
            this.mList.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public T remove(int pIndex) {
        return (T)((Comparable)this.mList.remove(pIndex));
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public void clear() {
        this.mList.clear();
    }

    private int binarySearch(T pItem, boolean pReturnSequenceEndIfNoEqualItemFound) {
        int size = this.mList.size();
        int guess = this.binarySearch(0, size, pItem);
        if (guess >= 0) {
            return this.scanForEqualItem(0, size, guess, pItem, pReturnSequenceEndIfNoEqualItemFound);
        }
        return guess;
    }

    private int binarySearch(int pStart, int pEnd, T pItem) {
        int low = pStart;
        int high = pEnd - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)this.mList.get(mid);
            int diff = pItem.compareTo((Comparable)midVal);
            if (diff > 0) {
                low = mid + 1;
                continue;
            }
            if (diff < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ListUtils.encodeInsertionIndex(low);
    }

    private int scanForEqualItem(int pStart, int pEnd, int pGuess, T pItem, boolean pReturnSequenceEndIfNoEqualItemFound) {
        int i;
        for (i = pGuess - 1; i >= pStart && pItem.compareTo(this.mList.get(i)) == 0; --i) {
        }
        ++i;
        while (i < pEnd) {
            Comparable item = (Comparable)this.mList.get(i);
            if (i <= pGuess) {
                if (pItem.equals(item)) {
                    return i;
                }
            } else if (pItem.compareTo((Comparable)item) == 0) {
                if (pItem.equals(item)) {
                    return i;
                }
            } else {
                return ListUtils.encodeInsertionIndex(i);
            }
            ++i;
        }
        if (pReturnSequenceEndIfNoEqualItemFound) {
            return i;
        }
        return -1;
    }
}

