/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.list;

import org.andengine.util.adt.list.IList;
import org.andengine.util.adt.list.ISortedList;
import org.andengine.util.adt.list.ListUtils;

public class UniqueList<T extends Comparable<T>>
implements ISortedList<T> {
    private final IList<T> mList;

    public UniqueList(IList<T> pList) {
        this.mList = pList;
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    public T get(int pIndex) throws IndexOutOfBoundsException {
        return (T)((Comparable)this.mList.get(pIndex));
    }

    @Override
    @Deprecated
    public void set(int pIndex, T pItem) throws IndexOutOfBoundsException {
        this.mList.set(pIndex, pItem);
    }

    @Override
    public int indexOf(T pItem) {
        return this.mList.indexOf(pItem);
    }

    @Override
    @Deprecated
    public void add(int pIndex, T pItem) {
        int index = this.indexOf(pItem);
        if (index < 0) {
            this.mList.add(pItem);
        }
    }

    @Override
    public void add(T pItem) {
        int index = this.indexOf(pItem);
        if (index < 0) {
            this.mList.add(ListUtils.encodeInsertionIndex(index), pItem);
        }
    }

    @Override
    public T removeFirst() {
        return (T)((Comparable)this.mList.removeFirst());
    }

    @Override
    public T removeLast() {
        return (T)((Comparable)this.mList.removeLast());
    }

    @Override
    public boolean remove(T pItem) {
        return this.mList.remove(pItem);
    }

    @Override
    public T remove(int pIndex) {
        return (T)((Comparable)this.mList.remove(pIndex));
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public void clear() {
        this.mList.clear();
    }
}

