/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.map;

import java.util.Arrays;

public class MultiKey<K> {
    private final K[] mKeys;
    private final int mCachedHashCode;

    public MultiKey(K ... pKeys) {
        this.mKeys = pKeys;
        this.mCachedHashCode = MultiKey.hash(pKeys);
    }

    public K[] getKeys() {
        return this.mKeys;
    }

    public boolean equals(Object pOther) {
        if (pOther == this) {
            return true;
        }
        if (pOther instanceof MultiKey) {
            MultiKey otherMultiKey = (MultiKey)pOther;
            return Arrays.equals(this.mKeys, otherMultiKey.mKeys);
        }
        return false;
    }

    public static int hash(Object ... pKeys) {
        int hashCode = 0;
        for (Object key : pKeys) {
            if (key == null) continue;
            hashCode ^= key.hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        return this.mCachedHashCode;
    }

    public String toString() {
        return "MultiKey" + Arrays.asList(this.mKeys).toString();
    }

    public K getKey(int pIndex) {
        return this.mKeys[pIndex];
    }

    public int size() {
        return this.mKeys.length;
    }
}

