/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.pool;

import org.andengine.util.adt.pool.GenericPool;
import org.andengine.util.adt.pool.PoolItem;

public abstract class Pool<T extends PoolItem>
extends GenericPool<T> {
    public Pool() {
    }

    public Pool(int pInitialSize) {
        super(pInitialSize);
    }

    public Pool(int pInitialSize, int pGrowth) {
        super(pInitialSize, pGrowth);
    }

    public Pool(int pInitialSize, int pGrowth, int pAvailableItemCountMaximum) {
        super(pInitialSize, pGrowth, pAvailableItemCountMaximum);
    }

    @Override
    protected T onHandleAllocatePoolItem() {
        PoolItem poolItem = (PoolItem)super.onHandleAllocatePoolItem();
        poolItem.mParent = this;
        return (T)poolItem;
    }

    @Override
    protected void onHandleObtainItem(T pPoolItem) {
        ((PoolItem)pPoolItem).mRecycled = false;
        ((PoolItem)pPoolItem).onObtain();
    }

    @Override
    protected void onHandleRecycleItem(T pPoolItem) {
        ((PoolItem)pPoolItem).onRecycle();
        ((PoolItem)pPoolItem).mRecycled = true;
    }

    @Override
    public synchronized void recyclePoolItem(T pPoolItem) {
        if (((PoolItem)pPoolItem).mParent == null) {
            throw new IllegalArgumentException("PoolItem not assigned to a pool!");
        }
        if (!((PoolItem)pPoolItem).isFromPool(this)) {
            throw new IllegalArgumentException("PoolItem from another pool!");
        }
        if (((PoolItem)pPoolItem).isRecycled()) {
            throw new IllegalArgumentException("PoolItem already recycled!");
        }
        super.recyclePoolItem(pPoolItem);
    }

    public synchronized boolean ownsPoolItem(T pPoolItem) {
        return ((PoolItem)pPoolItem).mParent == this;
    }

    void recycle(PoolItem pPoolItem) {
        this.recyclePoolItem((T)pPoolItem);
    }
}

