/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.pool;

import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.util.adt.list.ShiftList;
import org.andengine.util.adt.pool.Pool;
import org.andengine.util.adt.pool.PoolItem;
import org.andengine.util.adt.queue.IQueue;
import org.andengine.util.adt.queue.concurrent.SynchronizedQueue;

public abstract class PoolUpdateHandler<T extends PoolItem>
implements IUpdateHandler {
    private final Pool<T> mPool;
    private final IQueue<T> mScheduledPoolItemQueue = new SynchronizedQueue(new ShiftList());

    public PoolUpdateHandler() {
        this.mPool = new Pool<T>(){

            @Override
            protected T onAllocatePoolItem() {
                return PoolUpdateHandler.this.onAllocatePoolItem();
            }
        };
    }

    public PoolUpdateHandler(int pInitialPoolSize) {
        this.mPool = new Pool<T>(pInitialPoolSize){

            @Override
            protected T onAllocatePoolItem() {
                return PoolUpdateHandler.this.onAllocatePoolItem();
            }
        };
    }

    public PoolUpdateHandler(int pInitialPoolSize, int pGrowth) {
        this.mPool = new Pool<T>(pInitialPoolSize, pGrowth){

            @Override
            protected T onAllocatePoolItem() {
                return PoolUpdateHandler.this.onAllocatePoolItem();
            }
        };
    }

    public PoolUpdateHandler(int pInitialPoolSize, int pGrowth, int pAvailableItemCountMaximum) {
        this.mPool = new Pool<T>(pInitialPoolSize, pGrowth, pAvailableItemCountMaximum){

            @Override
            protected T onAllocatePoolItem() {
                return PoolUpdateHandler.this.onAllocatePoolItem();
            }
        };
    }

    protected abstract T onAllocatePoolItem();

    protected abstract void onHandlePoolItem(T var1);

    @Override
    public void onUpdate(float pSecondsElapsed) {
        PoolItem item;
        IQueue<T> scheduledPoolItemQueue = this.mScheduledPoolItemQueue;
        Pool<PoolItem> pool = this.mPool;
        while ((item = (PoolItem)scheduledPoolItemQueue.poll()) != null) {
            this.onHandlePoolItem(item);
            pool.recyclePoolItem(item);
        }
    }

    @Override
    public void reset() {
        PoolItem item;
        IQueue<T> scheduledPoolItemQueue = this.mScheduledPoolItemQueue;
        Pool<PoolItem> pool = this.mPool;
        while ((item = (PoolItem)scheduledPoolItemQueue.poll()) != null) {
            pool.recyclePoolItem(item);
        }
    }

    public T obtainPoolItem() {
        return (T)((PoolItem)this.mPool.obtainPoolItem());
    }

    public void postPoolItem(T pPoolItem) {
        if (pPoolItem == null) {
            throw new IllegalArgumentException("PoolItem already recycled!");
        }
        if (!this.mPool.ownsPoolItem(pPoolItem)) {
            throw new IllegalArgumentException("PoolItem from another pool!");
        }
        this.mScheduledPoolItemQueue.enter(pPoolItem);
    }
}

