/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.spatial.quadtree;

import java.util.ArrayList;
import java.util.List;
import org.andengine.util.IMatcher;
import org.andengine.util.adt.bounds.BoundsSplit;
import org.andengine.util.adt.bounds.IIntBounds;
import org.andengine.util.adt.bounds.IntBounds;
import org.andengine.util.adt.spatial.ISpatialItem;
import org.andengine.util.adt.spatial.bounds.util.IntBoundsUtils;
import org.andengine.util.adt.spatial.quadtree.QuadTree;

public class IntQuadTree<T extends ISpatialItem<IIntBounds>>
extends QuadTree<IIntBounds, T>
implements IIntBounds {
    private final IntBounds mQueryIntBounds = new IntBounds(0, 0, 0, 0);

    public IntQuadTree(IIntBounds pIntBounds) {
        super(pIntBounds);
    }

    public IntQuadTree(int pXMin, int pYMin, int pXMax, int pYMax) {
        super(new IntBounds(pXMin, pYMin, pXMax, pYMax));
    }

    public IntQuadTree(IIntBounds pIntBounds, int pMaxLevel) {
        super(pIntBounds, pMaxLevel);
    }

    public IntQuadTree(int pXMin, int pYMin, int pXMax, int pYMax, int pMaxLevel) {
        super(new IntBounds(pXMin, pYMin, pXMax, pYMax), pMaxLevel);
    }

    protected IntQuadTreeNode initRoot(IIntBounds pIntBounds) {
        return new IntQuadTreeNode(0, pIntBounds);
    }

    @Override
    public int getXMin() {
        return this.getRoot().getXMin();
    }

    @Override
    public int getYMin() {
        return this.getRoot().getYMin();
    }

    @Override
    public int getXMax() {
        return this.getRoot().getXMax();
    }

    @Override
    public int getYMax() {
        return this.getRoot().getYMax();
    }

    @Override
    protected IntQuadTreeNode getRoot() {
        return (IntQuadTreeNode)this.mRoot;
    }

    @Override
    public synchronized ArrayList<T> query(int pX, int pY) {
        this.mQueryIntBounds.set(pX, pY);
        return this.query(this.mQueryIntBounds);
    }

    public synchronized <L extends List<T>> L query(int pX, int pY, L pResult) {
        this.mQueryIntBounds.set(pX, pY);
        return this.query(this.mQueryIntBounds, pResult);
    }

    public synchronized ArrayList<T> query(int pX, int pY, IMatcher<T> pMatcher) {
        this.mQueryIntBounds.set(pX, pY);
        return this.query(this.mQueryIntBounds, pMatcher);
    }

    public synchronized <L extends List<T>> L query(int pX, int pY, IMatcher<T> pMatcher, L pResult) {
        this.mQueryIntBounds.set(pX, pY);
        return this.query(this.mQueryIntBounds, pMatcher, pResult);
    }

    public synchronized ArrayList<T> query(int pXMin, int pYMin, int pXMax, int pYMax) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.query(this.mQueryIntBounds);
    }

    public synchronized <L extends List<T>> L query(int pXMin, int pYMin, int pXMax, int pYMax, L pResult) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.query(this.mQueryIntBounds, pResult);
    }

    public synchronized ArrayList<T> query(int pXMin, int pYMin, int pXMax, int pYMax, IMatcher<T> pMatcher) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.query(this.mQueryIntBounds, pMatcher);
    }

    public synchronized <L extends List<T>> L query(int pXMin, int pYMin, int pXMax, int pYMax, IMatcher<T> pMatcher, L pResult) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.query(this.mQueryIntBounds, pMatcher, pResult);
    }

    public synchronized <L extends List<S>, S extends T> L queryForSubclass(int pX, int pY, IMatcher<T> pMatcher, L pResult) throws ClassCastException {
        this.mQueryIntBounds.set(pX, pY);
        return this.queryForSubclass(this.mQueryIntBounds, pMatcher, pResult);
    }

    public synchronized <L extends List<S>, S extends T> L queryForSubclass(int pXMin, int pYMin, int pXMax, int pYMax, IMatcher<T> pMatcher, L pResult) throws ClassCastException {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.queryForSubclass(this.mQueryIntBounds, pMatcher, pResult);
    }

    public synchronized boolean containsAny(int pX, int pY) {
        this.mQueryIntBounds.set(pX, pY);
        return this.containsAny(this.mQueryIntBounds);
    }

    public synchronized boolean containsAny(int pXMin, int pYMin, int pXMax, int pYMax) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.containsAny(this.mQueryIntBounds);
    }

    public synchronized boolean containsAny(int pX, int pY, IMatcher<T> pMatcher) {
        this.mQueryIntBounds.set(pX, pY);
        return this.containsAny(this.mQueryIntBounds, pMatcher);
    }

    public synchronized boolean containsAny(int pXMin, int pYMin, int pXMax, int pYMax, IMatcher<T> pMatcher) {
        this.mQueryIntBounds.set(pXMin, pYMin, pXMax, pYMax);
        return this.containsAny(this.mQueryIntBounds, pMatcher);
    }

    public class IntQuadTreeNode
    extends QuadTree.QuadTreeNode
    implements IIntBounds {
        private final int mXMin;
        private final int mYMin;
        private final int mXMax;
        private final int mYMax;

        public IntQuadTreeNode(int pLevel, IIntBounds pIntBounds) {
            this(pLevel, pIntBounds.getXMin(), pIntBounds.getYMin(), pIntBounds.getXMax(), pIntBounds.getYMax());
        }

        public IntQuadTreeNode(int pLevel, int pXMin, int pYMin, int pXMax, int pYMax) {
            super(IntQuadTree.this, pLevel);
            this.mXMin = pXMin;
            this.mYMin = pYMin;
            this.mXMax = pXMax;
            this.mYMax = pYMax;
            if (pXMin > pXMax) {
                throw new IllegalArgumentException("pXMin must be smaller or equal to pXMax.");
            }
            if (pYMin > pYMax) {
                throw new IllegalArgumentException("pYMin must be smaller or equal to pYMax.");
            }
        }

        @Override
        public int getXMin() {
            return this.mXMin;
        }

        @Override
        public int getYMin() {
            return this.mYMin;
        }

        @Override
        public int getXMax() {
            return this.mXMax;
        }

        @Override
        public int getYMax() {
            return this.mYMax;
        }

        public int getWidth() {
            return this.mXMax - this.mXMin + 1;
        }

        public int getHeight() {
            return this.mYMax - this.mYMin + 1;
        }

        @Override
        protected IntQuadTreeNode split(BoundsSplit pBoundsSplit) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width <= 2 && height <= 2) {
                throw new BoundsSplit.BoundsSplitException();
            }
            int xMin = this.getXMin(pBoundsSplit);
            int yMin = this.getYMin(pBoundsSplit);
            int xMax = this.getXMax(pBoundsSplit);
            int yMax = this.getYMax(pBoundsSplit);
            return new IntQuadTreeNode(this.mLevel + 1, xMin, yMin, xMax, yMax);
        }

        protected boolean contains(IIntBounds pIntBounds) {
            return this.contains(pIntBounds.getXMin(), pIntBounds.getYMin(), pIntBounds.getXMax(), pIntBounds.getYMax());
        }

        protected boolean contains(BoundsSplit pBoundsSplit, IIntBounds pIntBounds) {
            return IntBoundsUtils.contains(this.getXMin(pBoundsSplit), this.getYMin(pBoundsSplit), this.getXMax(pBoundsSplit), this.getYMax(pBoundsSplit), pIntBounds.getXMin(), pIntBounds.getYMin(), pIntBounds.getXMax(), pIntBounds.getYMax());
        }

        protected boolean intersects(IIntBounds pIntBounds) {
            return IntBoundsUtils.intersects(this.mXMin, this.mYMin, this.mXMax, this.mYMax, pIntBounds.getXMin(), pIntBounds.getYMin(), pIntBounds.getXMax(), pIntBounds.getYMax());
        }

        protected boolean intersects(IIntBounds pIntBoundsA, IIntBounds pIntBoundsB) {
            return IntBoundsUtils.intersects(pIntBoundsA, pIntBoundsB);
        }

        protected boolean containedBy(IIntBounds pBounds) {
            return IntBoundsUtils.contains(pBounds.getXMin(), pBounds.getYMin(), pBounds.getXMax(), pBounds.getYMax(), this.mXMin, this.mYMin, this.mXMax, this.mYMax);
        }

        @Override
        protected void appendBoundsToString(StringBuilder pStringBuilder) {
            pStringBuilder.append("[XMin: ").append(this.mXMin).append(", YMin: ").append(this.mYMin).append(", XMax: ").append(this.mXMax).append(", YMax: ").append(this.mYMax).append("]");
        }

        private int getXMin(BoundsSplit pBoundsSplit) {
            int width = this.getWidth();
            int halfWidth = width / 2;
            if (width <= 2) {
                switch (pBoundsSplit) {
                    case TOP_LEFT: 
                    case BOTTOM_LEFT: {
                        return this.mXMin;
                    }
                    case BOTTOM_RIGHT: 
                    case TOP_RIGHT: {
                        throw new BoundsSplit.BoundsSplitException();
                    }
                }
                throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
            }
            switch (pBoundsSplit) {
                case TOP_LEFT: {
                    return this.mXMin;
                }
                case TOP_RIGHT: {
                    return this.mXMin + halfWidth;
                }
                case BOTTOM_LEFT: {
                    return this.mXMin;
                }
                case BOTTOM_RIGHT: {
                    return this.mXMin + halfWidth;
                }
            }
            throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
        }

        private int getYMin(BoundsSplit pBoundsSplit) {
            int height = this.getHeight();
            int halfHeight = height / 2;
            if (height <= 2) {
                switch (pBoundsSplit) {
                    case TOP_LEFT: 
                    case TOP_RIGHT: {
                        return this.mYMin;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_RIGHT: {
                        throw new BoundsSplit.BoundsSplitException();
                    }
                }
                throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
            }
            switch (pBoundsSplit) {
                case TOP_LEFT: {
                    return this.mYMin;
                }
                case TOP_RIGHT: {
                    return this.mYMin;
                }
                case BOTTOM_LEFT: {
                    return this.mYMin + halfHeight;
                }
                case BOTTOM_RIGHT: {
                    return this.mYMin + halfHeight;
                }
            }
            throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
        }

        private int getXMax(BoundsSplit pBoundsSplit) {
            int width = this.getWidth();
            int halfWidth = width / 2;
            if (width <= 2) {
                switch (pBoundsSplit) {
                    case TOP_LEFT: 
                    case BOTTOM_LEFT: {
                        return this.mXMax;
                    }
                    case BOTTOM_RIGHT: 
                    case TOP_RIGHT: {
                        throw new BoundsSplit.BoundsSplitException();
                    }
                }
                throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
            }
            switch (pBoundsSplit) {
                case TOP_LEFT: {
                    return this.mXMin + halfWidth;
                }
                case TOP_RIGHT: {
                    return this.mXMax;
                }
                case BOTTOM_LEFT: {
                    return this.mXMin + halfWidth;
                }
                case BOTTOM_RIGHT: {
                    return this.mXMax;
                }
            }
            throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
        }

        private int getYMax(BoundsSplit pBoundsSplit) {
            int height = this.getHeight();
            int halfHeight = height / 2;
            if (height <= 2) {
                switch (pBoundsSplit) {
                    case TOP_LEFT: 
                    case TOP_RIGHT: {
                        return this.mYMax;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_RIGHT: {
                        throw new BoundsSplit.BoundsSplitException();
                    }
                }
                throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
            }
            switch (pBoundsSplit) {
                case TOP_LEFT: {
                    return this.mYMin + halfHeight;
                }
                case TOP_RIGHT: {
                    return this.mYMin + halfHeight;
                }
                case BOTTOM_LEFT: {
                    return this.mYMax;
                }
                case BOTTOM_RIGHT: {
                    return this.mYMax;
                }
            }
            throw new IllegalArgumentException("Unexpected " + BoundsSplit.class.getSimpleName() + ": '" + (Object)((Object)pBoundsSplit) + "'.");
        }

        public boolean intersects(int pXMin, int pYMin, int pXMax, int pYMax) {
            return IntBoundsUtils.intersects(this.mXMin, this.mYMin, this.mXMax, this.mYMax, pXMin, pYMin, pXMax, pYMax);
        }

        public boolean contains(int pXMin, int pYMin, int pXMax, int pYMax) {
            return IntBoundsUtils.contains(this.mXMin, this.mYMin, this.mXMax, this.mYMax, pXMin, pYMin, pXMax, pYMax);
        }
    }
}

