/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.spatial.quadtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.andengine.util.IMatcher;
import org.andengine.util.adt.bounds.BoundsSplit;
import org.andengine.util.adt.bounds.IBounds;
import org.andengine.util.adt.spatial.ISpatialItem;
import org.andengine.util.call.ParameterCallable;
import org.andengine.util.debug.Debug;
import org.andengine.util.exception.AndEngineRuntimeException;

public abstract class QuadTree<B extends IBounds, T extends ISpatialItem<B>>
implements IBounds {
    protected static final int LEVEL_ROOT = 0;
    protected static final int LEVEL_MAX_DEFAULT = 8;
    protected final B mBounds;
    protected final QuadTreeNode mRoot;
    protected final int mMaxLevel;

    public QuadTree(B pBounds) {
        this(pBounds, 8);
    }

    protected QuadTree(B pBounds, int pMaxLevel) {
        this.mBounds = pBounds;
        this.mMaxLevel = pMaxLevel;
        this.mRoot = this.initRoot(pBounds);
    }

    protected abstract QuadTreeNode initRoot(B var1);

    public int getMaxLevel() {
        return this.mMaxLevel;
    }

    public B getBounds() {
        return this.mBounds;
    }

    protected abstract QuadTreeNode getRoot();

    public String toString() {
        StringBuilder sb = new StringBuilder().append('[').append(" Class: ").append(this.getClass().getSimpleName()).append('\n').append('\t').append("MaxLevel: ").append(this.mMaxLevel).append(',').append('\n').append('\t').append("Bounds: ");
        this.mRoot.appendBoundsToString(sb);
        sb.append(',').append('\n').append('\t').append("Root:").append('\n').append(this.mRoot.toString(2)).append('\n').append(']');
        return sb.toString();
    }

    public synchronized int getItemCount() {
        return this.mRoot.getItemCount();
    }

    public synchronized boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public synchronized void add(T pItem) {
        this.add(pItem, pItem.getBounds());
    }

    public synchronized void addAll(T ... pItems) {
        for (T item : pItems) {
            this.add(item);
        }
    }

    public synchronized void addAll(ArrayList<T> pItems) {
        int itemCount = pItems.size();
        for (int i = 0; i < itemCount; ++i) {
            this.add((ISpatialItem)pItems.get(i));
        }
    }

    public synchronized void addAll(Collection<T> pItems) {
        for (ISpatialItem item : pItems) {
            this.add(item);
        }
    }

    @Deprecated
    public synchronized void add(T pItem, B pBounds) {
        if (!this.mRoot.contains(pBounds)) {
            Debug.w("pBounds are out of the bounds of this " + this.getClass().getSimpleName() + ".");
            this.mRoot.addItemSafe(pItem);
            return;
        }
        this.mRoot.add(pItem, pBounds);
    }

    public synchronized void move(T pItem, B pBounds) throws AndEngineRuntimeException {
        boolean success = this.remove(pItem, pBounds);
        if (!success) {
            throw new AndEngineRuntimeException("Failed to remove item: '" + pItem.toString() + " from old bounds: '" + pBounds.toString() + "'.");
        }
        this.add(pItem);
    }

    @Deprecated
    public synchronized void move(T pItem, B pOldBounds, B pNewBounds) throws AndEngineRuntimeException {
        boolean success = this.remove(pItem, pOldBounds);
        if (!success) {
            throw new AndEngineRuntimeException("Failed to remove item: '" + pItem.toString() + " from old bounds: '" + pOldBounds.toString() + "'.");
        }
        this.add(pItem, pNewBounds);
    }

    public synchronized boolean remove(T pItem) {
        return this.remove(pItem, pItem.getBounds());
    }

    public synchronized boolean remove(T pItem, B pBounds) {
        return this.mRoot.remove(pItem, pBounds);
    }

    public synchronized ArrayList<T> query(B pBounds) {
        return this.query(pBounds, new ArrayList());
    }

    public synchronized <L extends List<T>> L query(B pBounds, L pResult) {
        return this.mRoot.query(pBounds, pResult);
    }

    public synchronized ArrayList<T> query(B pBounds, IMatcher<T> pMatcher) {
        return this.query(pBounds, pMatcher, new ArrayList());
    }

    public synchronized <L extends List<T>> L query(B pBounds, IMatcher<T> pMatcher, L pResult) {
        return this.mRoot.query(pBounds, pMatcher, pResult);
    }

    public synchronized <L extends List<S>, S extends T> L queryForSubclass(B pBounds, IMatcher<T> pMatcher, L pResult) throws ClassCastException {
        return this.mRoot.queryForSubclass(pBounds, pMatcher, pResult);
    }

    public synchronized boolean containsAny(B pBounds) {
        return this.mRoot.containsAny(pBounds);
    }

    public synchronized boolean containsAny(B pBounds, IMatcher<T> pMatcher) {
        return this.mRoot.containsAny(pBounds, pMatcher);
    }

    public synchronized void callItems(ParameterCallable<T> pParameterCallable) {
        this.mRoot.callItems(pParameterCallable);
    }

    public synchronized void callNodes(ParameterCallable<QuadTreeNode> pParameterCallable) {
        this.mRoot.callNodes(pParameterCallable);
    }

    public synchronized void clear() {
        this.mRoot.clear();
    }

    public abstract class QuadTreeNode
    implements IBounds {
        protected final int mLevel;
        protected List<T> mItems;
        protected QuadTreeNode mTopLeftChild;
        protected QuadTreeNode mTopRightChild;
        protected QuadTreeNode mBottomLeftChild;
        protected QuadTreeNode mBottomRightChild;

        protected QuadTreeNode(int pLevel) {
            this.mLevel = pLevel;
        }

        public boolean hasChildren() {
            return this.mTopLeftChild == null && this.mTopRightChild == null && this.mBottomLeftChild != null && this.mBottomRightChild != null;
        }

        public List<T> getItems() {
            return this.mItems;
        }

        protected abstract boolean contains(B var1);

        protected abstract boolean contains(BoundsSplit var1, B var2);

        protected abstract boolean containedBy(B var1);

        protected abstract boolean intersects(B var1);

        protected abstract boolean intersects(B var1, B var2);

        protected abstract QuadTreeNode split(BoundsSplit var1);

        protected abstract void appendBoundsToString(StringBuilder var1);

        public String toString() {
            return this.toString(0);
        }

        public String toString(int pIndent) {
            char[] indents = new char[pIndent];
            Arrays.fill(indents, '\t');
            StringBuilder sb = new StringBuilder().append(indents).append('[').append(" Class: ").append(this.getClass().getSimpleName()).append('\n').append(indents).append('\t').append("Level: ").append(this.mLevel).append(',').append('\n').append(indents).append('\t').append("Bounds: ");
            this.appendBoundsToString(sb);
            sb.append(',').append('\n').append(indents).append("\tItems: ");
            if (this.mItems != null) {
                sb.append(this.mItems.toString());
            } else {
                sb.append("[]");
            }
            sb.append('\n').append(indents).append('\t').append("Children: [");
            if (this.mTopLeftChild == null && this.mTopRightChild == null && this.mBottomLeftChild == null && this.mBottomRightChild == null) {
                sb.append(']');
            } else {
                if (this.mTopLeftChild != null) {
                    sb.append('\n');
                    sb.append(this.mTopLeftChild.toString(pIndent + 2));
                    if (this.mTopRightChild != null || this.mBottomLeftChild != null || this.mBottomRightChild != null) {
                        sb.append(',');
                    }
                }
                if (this.mTopRightChild != null) {
                    sb.append('\n');
                    sb.append(this.mTopRightChild.toString(pIndent + 2));
                    if (this.mBottomLeftChild != null || this.mBottomRightChild != null) {
                        sb.append(',');
                    }
                }
                if (this.mBottomLeftChild != null) {
                    sb.append('\n');
                    sb.append(this.mBottomLeftChild.toString(pIndent + 2));
                    if (this.mBottomRightChild != null) {
                        sb.append(',');
                    }
                }
                if (this.mBottomRightChild != null) {
                    sb.append('\n');
                    sb.append(this.mBottomRightChild.toString(pIndent + 2));
                }
                sb.append('\n').append(indents).append('\t').append(']');
            }
            sb.append('\n').append(indents).append(']');
            return sb.toString();
        }

        public int getItemCount() {
            int count = this.mItems == null ? 0 : this.mItems.size();
            if (this.mTopLeftChild != null) {
                count += this.mTopLeftChild.getItemCount();
            }
            if (this.mTopRightChild != null) {
                count += this.mTopRightChild.getItemCount();
            }
            if (this.mBottomLeftChild != null) {
                count += this.mBottomLeftChild.getItemCount();
            }
            if (this.mBottomRightChild != null) {
                count += this.mBottomRightChild.getItemCount();
            }
            return count;
        }

        public void callItems(ParameterCallable<T> pParameterCallable) {
            if (this.mItems != null) {
                int itemCount = this.mItems.size();
                for (int i = 0; i < itemCount; ++i) {
                    ISpatialItem item = (ISpatialItem)this.mItems.get(i);
                    pParameterCallable.call(item);
                }
            }
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.callItems(pParameterCallable);
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.callItems(pParameterCallable);
            }
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.callItems(pParameterCallable);
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.callItems(pParameterCallable);
            }
        }

        public void callNodes(ParameterCallable<QuadTreeNode> pParameterCallable) {
            pParameterCallable.call(this);
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.callNodes(pParameterCallable);
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.callNodes(pParameterCallable);
            }
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.callNodes(pParameterCallable);
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.callNodes(pParameterCallable);
            }
        }

        public ArrayList<T> getItemsAndItemsBelow() {
            return this.getItemsAndItemsBelow(new ArrayList());
        }

        public <L extends List<T>> L getItemsAndItemsBelow(L pResult) {
            if (this.mItems != null) {
                pResult.addAll(this.mItems);
            }
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.getItemsAndItemsBelow(pResult);
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.getItemsAndItemsBelow(pResult);
            }
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.getItemsAndItemsBelow(pResult);
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.getItemsAndItemsBelow(pResult);
            }
            return pResult;
        }

        public ArrayList<T> getItemsAndItemsBelow(IMatcher<T> pMatcher) {
            return this.getItemsAndItemsBelow(pMatcher, new ArrayList());
        }

        public <L extends List<T>> L getItemsAndItemsBelow(IMatcher<T> pMatcher, L pResult) {
            if (this.mItems != null) {
                for (ISpatialItem item : this.mItems) {
                    if (!pMatcher.matches(item)) continue;
                    pResult.add((ISpatialItem)item);
                }
            }
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.getItemsAndItemsBelow(pMatcher, pResult);
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.getItemsAndItemsBelow(pMatcher, pResult);
            }
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.getItemsAndItemsBelow(pMatcher, pResult);
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.getItemsAndItemsBelow(pMatcher, pResult);
            }
            return pResult;
        }

        public <L extends List<S>, S extends T> L getItemsAndItemsBelowForSubclass(IMatcher<T> pMatcher, L pResult) throws ClassCastException {
            if (this.mItems != null) {
                int itemCount = this.mItems.size();
                for (int i = 0; i < itemCount; ++i) {
                    ISpatialItem item = (ISpatialItem)this.mItems.get(i);
                    if (!pMatcher.matches(item)) continue;
                    pResult.add((ISpatialItem)item);
                }
            }
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.getItemsAndItemsBelowForSubclass(pMatcher, pResult);
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.getItemsAndItemsBelowForSubclass(pMatcher, pResult);
            }
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.getItemsAndItemsBelowForSubclass(pMatcher, pResult);
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.getItemsAndItemsBelowForSubclass(pMatcher, pResult);
            }
            return pResult;
        }

        public ArrayList<T> query(B pBounds) {
            return this.query(pBounds, new ArrayList());
        }

        public <L extends List<T>> L query(B pBounds, L pResult) {
            if (this.mItems != null) {
                int itemCount = this.mItems.size();
                for (int i = 0; i < itemCount; ++i) {
                    ISpatialItem item = (ISpatialItem)this.mItems.get(i);
                    if (!this.intersects(pBounds, item.getBounds())) continue;
                    pResult.add((ISpatialItem)item);
                }
            }
            if (this.queryChild(pBounds, pResult, this.mTopLeftChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pResult, this.mTopRightChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pResult, this.mBottomLeftChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pResult, this.mBottomRightChild)) {
                return pResult;
            }
            return pResult;
        }

        public <L extends List<T>> L query(B pBounds, IMatcher<T> pMatcher, L pResult) {
            if (this.mItems != null) {
                for (ISpatialItem item : this.mItems) {
                    if (!this.intersects(pBounds, item.getBounds()) || !pMatcher.matches(item)) continue;
                    pResult.add((ISpatialItem)item);
                }
            }
            if (this.queryChild(pBounds, pMatcher, pResult, this.mTopLeftChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pMatcher, pResult, this.mTopRightChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pMatcher, pResult, this.mBottomLeftChild)) {
                return pResult;
            }
            if (this.queryChild(pBounds, pMatcher, pResult, this.mBottomRightChild)) {
                return pResult;
            }
            return pResult;
        }

        public <L extends List<S>, S extends T> L queryForSubclass(B pBounds, IMatcher<T> pMatcher, L pResult) throws ClassCastException {
            if (this.mItems != null) {
                for (ISpatialItem item : this.mItems) {
                    if (!this.intersects(pBounds, item.getBounds()) || !pMatcher.matches(item)) continue;
                    pResult.add((ISpatialItem)item);
                }
            }
            if (this.queryChildForSubclass(pBounds, pMatcher, pResult, this.mTopLeftChild)) {
                return pResult;
            }
            if (this.queryChildForSubclass(pBounds, pMatcher, pResult, this.mTopRightChild)) {
                return pResult;
            }
            if (this.queryChildForSubclass(pBounds, pMatcher, pResult, this.mBottomLeftChild)) {
                return pResult;
            }
            if (this.queryChildForSubclass(pBounds, pMatcher, pResult, this.mBottomRightChild)) {
                return pResult;
            }
            return pResult;
        }

        private <L extends List<T>> boolean queryChild(B pBounds, L pResult, QuadTreeNode pChild) {
            if (pChild == null) {
                return false;
            }
            if (pChild.contains(pBounds)) {
                pChild.query(pBounds, pResult);
                return true;
            }
            if (pChild.containedBy(pBounds)) {
                pChild.getItemsAndItemsBelow(pResult);
            } else if (pChild.intersects(pBounds)) {
                pChild.query(pBounds, pResult);
            }
            return false;
        }

        private <L extends List<T>> boolean queryChild(B pBounds, IMatcher<T> pMatcher, L pResult, QuadTreeNode pChild) {
            if (pChild == null) {
                return false;
            }
            if (pChild.contains(pBounds)) {
                pChild.query(pBounds, pMatcher, pResult);
                return true;
            }
            if (pChild.containedBy(pBounds)) {
                pChild.getItemsAndItemsBelow(pMatcher, pResult);
            } else if (pChild.intersects(pBounds)) {
                pChild.query(pBounds, pMatcher, pResult);
            }
            return false;
        }

        private <L extends List<S>, S extends T> boolean queryChildForSubclass(B pBounds, IMatcher<T> pMatcher, L pResult, QuadTreeNode pChild) throws ClassCastException {
            if (pChild == null) {
                return false;
            }
            if (pChild.contains(pBounds)) {
                pChild.queryForSubclass(pBounds, pMatcher, pResult);
                return true;
            }
            if (pChild.containedBy(pBounds)) {
                pChild.getItemsAndItemsBelowForSubclass(pMatcher, pResult);
            } else if (pChild.intersects(pBounds)) {
                pChild.queryForSubclass(pBounds, pMatcher, pResult);
            }
            return false;
        }

        public boolean containsAny(B pBounds, IMatcher<T> pMatcher) {
            if (this.mItems != null) {
                int itemCount = this.mItems.size();
                for (int i = 0; i < itemCount; ++i) {
                    ISpatialItem item = (ISpatialItem)this.mItems.get(i);
                    if (!this.intersects(pBounds, item.getBounds()) || !pMatcher.matches(item)) continue;
                    return true;
                }
            }
            if (this.containsAnyChild(pBounds, pMatcher, this.mTopLeftChild)) {
                return true;
            }
            if (this.containsAnyChild(pBounds, pMatcher, this.mTopRightChild)) {
                return true;
            }
            if (this.containsAnyChild(pBounds, pMatcher, this.mBottomLeftChild)) {
                return true;
            }
            return this.containsAnyChild(pBounds, pMatcher, this.mBottomRightChild);
        }

        public boolean containsAny(B pBounds) {
            if (this.mItems != null) {
                int itemCount = this.mItems.size();
                for (int i = 0; i < itemCount; ++i) {
                    ISpatialItem item = (ISpatialItem)this.mItems.get(i);
                    if (!this.intersects(pBounds, item.getBounds())) continue;
                    return true;
                }
            }
            if (this.containsAnyChild(pBounds, this.mTopLeftChild)) {
                return true;
            }
            if (this.containsAnyChild(pBounds, this.mTopRightChild)) {
                return true;
            }
            if (this.containsAnyChild(pBounds, this.mBottomLeftChild)) {
                return true;
            }
            return this.containsAnyChild(pBounds, this.mBottomRightChild);
        }

        private boolean containsAnyChild(B pBounds, IMatcher<T> pMatcher, QuadTreeNode pChild) {
            if (pChild == null) {
                return false;
            }
            return pChild.intersects(pBounds) && pChild.containsAny(pBounds, pMatcher);
        }

        private boolean containsAnyChild(B pBounds, QuadTreeNode pChild) {
            if (pChild == null) {
                return false;
            }
            return pChild.intersects(pBounds) && pChild.containsAny(pBounds);
        }

        public void add(T pItem, B pBounds) throws IllegalArgumentException {
            if (this.mLevel >= QuadTree.this.mMaxLevel) {
                this.addItemSafe(pItem);
                return;
            }
            if (this.mTopLeftChild != null && this.mTopLeftChild.contains(pBounds)) {
                this.mTopLeftChild.add(pItem, pBounds);
                return;
            }
            if (this.contains(BoundsSplit.TOP_LEFT, pBounds) && this.mTopLeftChild == null) {
                try {
                    this.mTopLeftChild = this.split(BoundsSplit.TOP_LEFT);
                    this.mTopLeftChild.add(pItem, pBounds);
                }
                catch (BoundsSplit.BoundsSplitException e) {
                    this.addItemSafe(pItem);
                }
                return;
            }
            if (this.mTopRightChild != null && this.mTopRightChild.contains(pBounds)) {
                this.mTopRightChild.add(pItem, pBounds);
                return;
            }
            if (this.contains(BoundsSplit.TOP_RIGHT, pBounds) && this.mTopRightChild == null) {
                try {
                    this.mTopRightChild = this.split(BoundsSplit.TOP_RIGHT);
                    this.mTopRightChild.add(pItem, pBounds);
                }
                catch (BoundsSplit.BoundsSplitException e) {
                    this.addItemSafe(pItem);
                }
                return;
            }
            if (this.mBottomLeftChild != null && this.mBottomLeftChild.contains(pBounds)) {
                this.mBottomLeftChild.add(pItem, pBounds);
                return;
            }
            if (this.contains(BoundsSplit.BOTTOM_LEFT, pBounds) && this.mBottomLeftChild == null) {
                try {
                    this.mBottomLeftChild = this.split(BoundsSplit.BOTTOM_LEFT);
                    this.mBottomLeftChild.add(pItem, pBounds);
                }
                catch (BoundsSplit.BoundsSplitException e) {
                    this.addItemSafe(pItem);
                }
                return;
            }
            if (this.mBottomRightChild != null && this.mBottomRightChild.contains(pBounds)) {
                this.mBottomRightChild.add(pItem, pBounds);
                return;
            }
            if (this.contains(BoundsSplit.BOTTOM_RIGHT, pBounds) && this.mBottomRightChild == null) {
                try {
                    this.mBottomRightChild = this.split(BoundsSplit.BOTTOM_RIGHT);
                    this.mBottomRightChild.add(pItem, pBounds);
                }
                catch (BoundsSplit.BoundsSplitException e) {
                    this.addItemSafe(pItem);
                }
                return;
            }
            this.addItemSafe(pItem);
        }

        public boolean remove(T pItem) throws IllegalArgumentException {
            return this.remove(pItem, pItem.getBounds());
        }

        public boolean remove(T pItem, B pBounds) throws IllegalArgumentException {
            if (!this.contains(pBounds)) {
                throw new IllegalArgumentException("pItem (" + pItem.toString() + ") is out of the bounds of this " + this.getClass().getSimpleName() + ".");
            }
            if (this.mTopLeftChild != null && this.mTopLeftChild.contains(pBounds)) {
                return this.mTopLeftChild.remove(pItem, pBounds);
            }
            if (this.mTopRightChild != null && this.mTopRightChild.contains(pBounds)) {
                return this.mTopRightChild.remove(pItem, pBounds);
            }
            if (this.mBottomLeftChild != null && this.mBottomLeftChild.contains(pBounds)) {
                return this.mBottomLeftChild.remove(pItem, pBounds);
            }
            if (this.mBottomRightChild != null && this.mBottomRightChild.contains(pBounds)) {
                return this.mBottomRightChild.remove(pItem, pBounds);
            }
            if (this.mItems == null) {
                return false;
            }
            return this.mItems.remove(pItem);
        }

        private void addItemSafe(T pItem) {
            if (this.mItems == null) {
                this.mItems = new ArrayList(1);
            }
            this.mItems.add(pItem);
        }

        protected void clear() {
            if (this.mBottomLeftChild != null) {
                this.mBottomLeftChild.clear();
                this.mBottomLeftChild = null;
            }
            if (this.mBottomRightChild != null) {
                this.mBottomRightChild.clear();
                this.mBottomRightChild = null;
            }
            if (this.mTopLeftChild != null) {
                this.mTopLeftChild.clear();
                this.mTopLeftChild = null;
            }
            if (this.mTopRightChild != null) {
                this.mTopRightChild.clear();
                this.mTopRightChild = null;
            }
            if (this.mItems != null) {
                this.mItems.clear();
                this.mItems = null;
            }
        }
    }
}

