/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.transformation;

public class Transformation {
    private float a = 1.0f;
    private float b = 0.0f;
    private float c = 0.0f;
    private float d = 1.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;

    public String toString() {
        return "Transformation{[" + this.a + ", " + this.c + ", " + this.tx + "][" + this.b + ", " + this.d + ", " + this.ty + "][0.0, 0.0, 1.0]}";
    }

    public final void reset() {
        this.setToIdentity();
    }

    public final void setToIdentity() {
        this.a = 1.0f;
        this.d = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.tx = 0.0f;
        this.ty = 0.0f;
    }

    public final void setTo(Transformation pTransformation) {
        this.a = pTransformation.a;
        this.d = pTransformation.d;
        this.b = pTransformation.b;
        this.c = pTransformation.c;
        this.tx = pTransformation.tx;
        this.ty = pTransformation.ty;
    }

    public final void preTranslate(float pX, float pY) {
        this.tx += pX * this.a + pY * this.c;
        this.ty += pX * this.b + pY * this.d;
    }

    public final void postTranslate(float pX, float pY) {
        this.tx += pX;
        this.ty += pY;
    }

    public final Transformation setToTranslate(float pX, float pY) {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 1.0f;
        this.tx = pX;
        this.ty = pY;
        return this;
    }

    public final void preRotate(float pAngle) {
        float angleRad = (float)Math.PI / 180 * pAngle;
        float sin = (float)Math.sin(angleRad);
        float cos = (float)Math.cos(angleRad);
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        this.a = cos * a + sin * c;
        this.b = cos * b + sin * d;
        this.c = cos * c - sin * a;
        this.d = cos * d - sin * b;
    }

    public final void postRotate(float pAngle) {
        float angleRad = (float)Math.PI / 180 * pAngle;
        float sin = (float)Math.sin(angleRad);
        float cos = (float)Math.cos(angleRad);
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        float tx = this.tx;
        float ty = this.ty;
        this.a = a * cos - b * sin;
        this.b = a * sin + b * cos;
        this.c = c * cos - d * sin;
        this.d = c * sin + d * cos;
        this.tx = tx * cos - ty * sin;
        this.ty = tx * sin + ty * cos;
    }

    public final Transformation setToRotate(float pAngle) {
        float cos;
        float angleRad = (float)Math.PI / 180 * pAngle;
        float sin = (float)Math.sin(angleRad);
        this.a = cos = (float)Math.cos(angleRad);
        this.b = sin;
        this.c = -sin;
        this.d = cos;
        this.tx = 0.0f;
        this.ty = 0.0f;
        return this;
    }

    public final void preScale(float pScaleX, float pScaleY) {
        this.a *= pScaleX;
        this.b *= pScaleX;
        this.c *= pScaleY;
        this.d *= pScaleY;
    }

    public final void postScale(float pScaleX, float pScaleY) {
        this.a *= pScaleX;
        this.b *= pScaleY;
        this.c *= pScaleX;
        this.d *= pScaleY;
        this.tx *= pScaleX;
        this.ty *= pScaleY;
    }

    public final Transformation setToScale(float pScaleX, float pScaleY) {
        this.a = pScaleX;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = pScaleY;
        this.tx = 0.0f;
        this.ty = 0.0f;
        return this;
    }

    public final void preSkew(float pSkewX, float pSkewY) {
        float tanX = (float)Math.tan((float)(-Math.PI) / 180 * pSkewX);
        float tanY = (float)Math.tan((float)(-Math.PI) / 180 * pSkewY);
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        float tx = this.tx;
        float ty = this.ty;
        this.a = a + tanY * c;
        this.b = b + tanY * d;
        this.c = tanX * a + c;
        this.d = tanX * b + d;
        this.tx = tx;
        this.ty = ty;
    }

    public final void postSkew(float pSkewX, float pSkewY) {
        float tanX = (float)Math.tan((float)(-Math.PI) / 180 * pSkewX);
        float tanY = (float)Math.tan((float)(-Math.PI) / 180 * pSkewY);
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        float tx = this.tx;
        float ty = this.ty;
        this.a = a + b * tanX;
        this.b = a * tanY + b;
        this.c = c + d * tanX;
        this.d = c * tanY + d;
        this.tx = tx + ty * tanX;
        this.ty = tx * tanY + ty;
    }

    public final Transformation setToSkew(float pSkewX, float pSkewY) {
        this.a = 1.0f;
        this.b = (float)Math.tan((float)(-Math.PI) / 180 * pSkewY);
        this.c = (float)Math.tan((float)(-Math.PI) / 180 * pSkewX);
        this.d = 1.0f;
        this.tx = 0.0f;
        this.ty = 0.0f;
        return this;
    }

    public final void postConcat(Transformation pTransformation) {
        this.postConcat(pTransformation.a, pTransformation.b, pTransformation.c, pTransformation.d, pTransformation.tx, pTransformation.ty);
    }

    private void postConcat(float pA, float pB, float pC, float pD, float pTX, float pTY) {
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        float tx = this.tx;
        float ty = this.ty;
        this.a = a * pA + b * pC;
        this.b = a * pB + b * pD;
        this.c = c * pA + d * pC;
        this.d = c * pB + d * pD;
        this.tx = tx * pA + ty * pC + pTX;
        this.ty = tx * pB + ty * pD + pTY;
    }

    public final void preConcat(Transformation pTransformation) {
        this.preConcat(pTransformation.a, pTransformation.b, pTransformation.c, pTransformation.d, pTransformation.tx, pTransformation.ty);
    }

    private void preConcat(float pA, float pB, float pC, float pD, float pTX, float pTY) {
        float a = this.a;
        float b = this.b;
        float c = this.c;
        float d = this.d;
        float tx = this.tx;
        float ty = this.ty;
        this.a = pA * a + pB * c;
        this.b = pA * b + pB * d;
        this.c = pC * a + pD * c;
        this.d = pC * b + pD * d;
        this.tx = pTX * a + pTY * c + tx;
        this.ty = pTX * b + pTY * d + ty;
    }

    public final void transform(float[] pVertices) {
        int count = pVertices.length >> 1;
        int i = 0;
        int j = 0;
        while (--count >= 0) {
            float x = pVertices[i++];
            float y = pVertices[i++];
            pVertices[j++] = x * this.a + y * this.c + this.tx;
            pVertices[j++] = x * this.b + y * this.d + this.ty;
        }
    }
}

