/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.adt.trie;

import android.util.SparseArray;
import org.andengine.util.adt.trie.ITrie;

public class Trie
implements ITrie {
    private static final int CHILDREN_SIZE_DEFAULT = 26;
    private final TrieNode mRoot = new TrieNode();

    @Override
    public void add(CharSequence pCharSequence) {
        this.mRoot.add(pCharSequence);
    }

    @Override
    public void add(CharSequence pCharSequence, int pStart, int pEnd) {
        this.mRoot.add(pCharSequence, pStart, pEnd);
    }

    @Override
    public boolean contains(CharSequence pCharSequence) {
        return this.mRoot.contains(pCharSequence);
    }

    @Override
    public boolean contains(CharSequence pCharSequence, int pStart, int pEnd) {
        return this.mRoot.contains(pCharSequence, pStart, pEnd);
    }

    public static class TrieNode
    implements ITrie {
        private SparseArray<TrieNode> mChildren;
        private boolean mWordEndFlag;

        public TrieNode() {
            this(false);
        }

        public TrieNode(boolean pWordEndFlag) {
            this.mWordEndFlag = pWordEndFlag;
        }

        @Override
        public void add(CharSequence pCharSequence) {
            int length = pCharSequence.length();
            if (length == 0) {
                return;
            }
            this.add(pCharSequence, 0, length);
        }

        @Override
        public void add(CharSequence pCharSequence, int pStart, int pEnd) {
            char character;
            TrieNode child;
            if (this.mChildren == null) {
                this.mChildren = new SparseArray(26);
            }
            if ((child = (TrieNode)this.mChildren.get((int)(character = pCharSequence.charAt(pStart)))) == null) {
                child = new TrieNode();
                this.mChildren.put((int)character, (Object)child);
            }
            if (pStart < pEnd - 1) {
                child.add(pCharSequence, pStart + 1, pEnd);
            } else {
                child.mWordEndFlag = true;
            }
        }

        @Override
        public boolean contains(CharSequence pCharSequence) {
            int length = pCharSequence.length();
            if (length == 0) {
                throw new IllegalArgumentException();
            }
            return this.contains(pCharSequence, 0, length);
        }

        @Override
        public boolean contains(CharSequence pCharSequence, int pStart, int pEnd) {
            if (this.mChildren == null) {
                return false;
            }
            char character = pCharSequence.charAt(pStart);
            TrieNode child = (TrieNode)this.mChildren.get((int)character);
            if (child == null) {
                return false;
            }
            if (pStart < pEnd - 1) {
                return child.contains(pCharSequence, pStart + 1, pEnd);
            }
            return child.mWordEndFlag;
        }
    }
}

