/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.algorithm.collision;

import org.andengine.opengl.util.VertexUtils;
import org.andengine.util.algorithm.collision.BaseCollisionChecker;
import org.andengine.util.algorithm.collision.LineCollisionChecker;

public class ShapeCollisionChecker
extends BaseCollisionChecker {
    public static boolean checkCollision(float[] pVerticesA, int pVertexCountA, float[] pVerticesB, int pVertexCountB) {
        return ShapeCollisionChecker.checkCollision(pVerticesA, pVertexCountA, 0, 1, 2, pVerticesB, pVertexCountB, 0, 1, 2);
    }

    public static boolean checkCollision(float[] pVerticesA, int pVertexCountA, int pVertexOffsetXA, int pVertexOffsetYA, int pVertexStrideA, float[] pVerticesB, int pVertexCountB, int pVertexOffsetXB, int pVertexOffsetYB, int pVertexStrideB) {
        for (int a = pVertexCountA - 2; a >= 0; --a) {
            if (!ShapeCollisionChecker.checkCollisionSub(pVerticesA, pVertexOffsetXA, pVertexOffsetYA, pVertexStrideA, a, a + 1, pVerticesB, pVertexCountB, pVertexOffsetXB, pVertexOffsetYB, pVertexStrideB)) continue;
            return true;
        }
        if (ShapeCollisionChecker.checkCollisionSub(pVerticesA, pVertexOffsetXA, pVertexOffsetYA, pVertexStrideA, pVertexCountA - 1, 0, pVerticesB, pVertexCountB, pVertexOffsetXB, pVertexOffsetYB, pVertexStrideB)) {
            return true;
        }
        if (ShapeCollisionChecker.checkContains(pVerticesA, pVertexCountA, VertexUtils.getVertex(pVerticesB, pVertexOffsetXB, pVertexStrideB, 0), VertexUtils.getVertex(pVerticesB, pVertexOffsetYB, pVertexStrideB, 0))) {
            return true;
        }
        return ShapeCollisionChecker.checkContains(pVerticesB, pVertexCountB, VertexUtils.getVertex(pVerticesA, pVertexOffsetXA, pVertexStrideA, 0), VertexUtils.getVertex(pVerticesA, pVertexOffsetYA, pVertexStrideA, 0));
    }

    private static boolean checkCollisionSub(float[] pVerticesA, int pVertexOffsetXA, int pVertexOffsetYA, int pVertexStrideA, int pVertexIndexA1, int pVertexIndexA2, float[] pVerticesB, int pVertexCountB, int pVertexOffsetXB, int pVertexOffsetYB, int pVertexStrideB) {
        float vertexB2Y;
        float vertexB2X;
        float vertexB1Y;
        float vertexA1X = VertexUtils.getVertex(pVerticesA, pVertexOffsetXA, pVertexStrideA, pVertexIndexA1);
        float vertexA1Y = VertexUtils.getVertex(pVerticesA, pVertexOffsetYA, pVertexStrideA, pVertexIndexA1);
        float vertexA2X = VertexUtils.getVertex(pVerticesA, pVertexOffsetXA, pVertexStrideA, pVertexIndexA2);
        float vertexA2Y = VertexUtils.getVertex(pVerticesA, pVertexOffsetYA, pVertexStrideA, pVertexIndexA2);
        for (int b = pVertexCountB - 2; b >= 0; --b) {
            float vertexB2Y2;
            float vertexB2X2;
            float vertexB1Y2;
            float vertexB1X = VertexUtils.getVertex(pVerticesB, pVertexOffsetXB, pVertexStrideB, b);
            if (!LineCollisionChecker.checkLineCollision(vertexA1X, vertexA1Y, vertexA2X, vertexA2Y, vertexB1X, vertexB1Y2 = VertexUtils.getVertex(pVerticesB, pVertexOffsetYB, pVertexStrideB, b), vertexB2X2 = VertexUtils.getVertex(pVerticesB, pVertexOffsetXB, pVertexStrideB, b + 1), vertexB2Y2 = VertexUtils.getVertex(pVerticesB, pVertexOffsetYB, pVertexStrideB, b + 1))) continue;
            return true;
        }
        float vertexB1X = VertexUtils.getVertex(pVerticesB, pVertexOffsetXB, pVertexStrideB, pVertexCountB - 1);
        return LineCollisionChecker.checkLineCollision(vertexA1X, vertexA1Y, vertexA2X, vertexA2Y, vertexB1X, vertexB1Y = VertexUtils.getVertex(pVerticesB, pVertexOffsetYB, pVertexStrideB, pVertexCountB - 1), vertexB2X = VertexUtils.getVertex(pVerticesB, pVertexOffsetXB, pVertexStrideB, 0), vertexB2Y = VertexUtils.getVertex(pVerticesB, pVertexOffsetYB, pVertexStrideB, 0));
    }

    public static boolean checkContains(float[] pVertices, int pVertexCount, float pX, float pY) {
        return ShapeCollisionChecker.checkContains(pVertices, pVertexCount, 0, 1, 2, pX, pY);
    }

    public static boolean checkContains(float[] pVertices, int pVertexCount, int pVertexOffsetX, int pVertexOffsetY, int pVertexStride, float pX, float pY) {
        boolean odd = false;
        int j = pVertexCount - 1;
        int i = 0;
        while (i < pVertexCount) {
            float vertexXI = VertexUtils.getVertex(pVertices, pVertexOffsetX, pVertexStride, i);
            float vertexYI = VertexUtils.getVertex(pVertices, pVertexOffsetY, pVertexStride, i);
            float vertexXJ = VertexUtils.getVertex(pVertices, pVertexOffsetX, pVertexStride, j);
            float vertexYJ = VertexUtils.getVertex(pVertices, pVertexOffsetY, pVertexStride, j);
            if ((vertexYI < pY && vertexYJ >= pY || vertexYJ < pY && vertexYI >= pY) && (vertexXI <= pX || vertexXJ <= pX)) {
                odd ^= vertexXI + (pY - vertexYI) / (vertexYJ - vertexYI) * (vertexXJ - vertexXI) < pX;
            }
            j = i++;
        }
        return odd;
    }
}

