/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.algorithm.hull;

import org.andengine.opengl.util.VertexUtils;
import org.andengine.util.algorithm.hull.HullUtils;
import org.andengine.util.algorithm.hull.IHullAlgorithm;
import org.andengine.util.math.MathUtils;

public class JarvisMarch
implements IHullAlgorithm {
    @Override
    public int computeHull(float[] pVertices, int pVertexCount, int pVertexOffsetX, int pVertexOffsetY, int pVertexStride) {
        return JarvisMarch.jarvisMarch(pVertices, pVertexCount, pVertexOffsetX, pVertexOffsetY, pVertexStride);
    }

    private static int jarvisMarch(float[] pVertices, int pVertexCount, int pVertexOffsetX, int pVertexOffsetY, int pVertexStride) {
        int nextHullVertexIndex;
        int firstHullVertexIndex = HullUtils.indexOfLowestVertex(pVertices, pVertexCount, pVertexOffsetY, pVertexStride);
        float firstHullVertexX = VertexUtils.getVertex(pVertices, pVertexOffsetX, pVertexStride, firstHullVertexIndex);
        float firstHullVertexY = VertexUtils.getVertex(pVertices, pVertexOffsetY, pVertexStride, firstHullVertexIndex);
        int hullVertexCount = 0;
        int currentHullVertexIndex = firstHullVertexIndex;
        float currentHullVertexAngle = 0.0f;
        do {
            HullUtils.swap(pVertices, pVertexStride, hullVertexCount, currentHullVertexIndex);
            float currentHullPointVertexX = VertexUtils.getVertex(pVertices, pVertexOffsetX, pVertexStride, hullVertexCount);
            float currentHullPointVertexY = VertexUtils.getVertex(pVertices, pVertexOffsetY, pVertexStride, hullVertexCount);
            nextHullVertexIndex = 0;
            float nextHullVertexAngle = (float)Math.PI * 2;
            for (int j = ++hullVertexCount; j < pVertexCount; ++j) {
                float possibleNextHullVertexX = VertexUtils.getVertex(pVertices, pVertexOffsetX, pVertexStride, j);
                float possibleNextHullVertexY = VertexUtils.getVertex(pVertices, pVertexOffsetY, pVertexStride, j);
                if (currentHullPointVertexX == possibleNextHullVertexX && currentHullPointVertexY == possibleNextHullVertexY) continue;
                float dY = possibleNextHullVertexY - currentHullPointVertexY;
                float dX = possibleNextHullVertexX - currentHullPointVertexX;
                float possibleNextHullVertexAngle = MathUtils.atan2(dY, dX);
                if (possibleNextHullVertexAngle < 0.0f) {
                    possibleNextHullVertexAngle += (float)Math.PI * 2;
                }
                if (!(possibleNextHullVertexAngle >= currentHullVertexAngle) || !(possibleNextHullVertexAngle <= nextHullVertexAngle)) continue;
                nextHullVertexIndex = j;
                nextHullVertexAngle = possibleNextHullVertexAngle;
            }
            if (hullVertexCount > 1) {
                float dY = firstHullVertexY - currentHullPointVertexY;
                float dX = firstHullVertexX - currentHullPointVertexX;
                float possibleNextHullVertexAngle = MathUtils.atan2(dY, dX);
                if (possibleNextHullVertexAngle < 0.0f) {
                    possibleNextHullVertexAngle += (float)Math.PI * 2;
                }
                if (possibleNextHullVertexAngle >= currentHullVertexAngle && possibleNextHullVertexAngle <= nextHullVertexAngle) break;
            }
            currentHullVertexAngle = nextHullVertexAngle;
        } while ((currentHullVertexIndex = nextHullVertexIndex) > 0);
        return hullVertexCount;
    }
}

