/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.algorithm.path;

import org.andengine.util.algorithm.path.Direction;

public class Path {
    private final int[] mXs;
    private final int[] mYs;

    public Path(int pLength) {
        this.mXs = new int[pLength];
        this.mYs = new int[pLength];
    }

    public int getLength() {
        return this.mXs.length;
    }

    public int getFromX() {
        return this.getX(0);
    }

    public int getFromY() {
        return this.getY(0);
    }

    public int getToX() {
        return this.getX(this.getLength() - 1);
    }

    public int getToY() {
        return this.getY(this.getLength() - 1);
    }

    public int getX(int pIndex) {
        return this.mXs[pIndex];
    }

    public int getY(int pIndex) {
        return this.mYs[pIndex];
    }

    public void set(int pIndex, int pX, int pY) {
        this.mXs[pIndex] = pX;
        this.mYs[pIndex] = pY;
    }

    public boolean contains(int pX, int pY) {
        int[] xs = this.mXs;
        int[] ys = this.mYs;
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (xs[i] != pX || ys[i] != pY) continue;
            return true;
        }
        return false;
    }

    public Direction getDirectionToPreviousStep(int pIndex) {
        if (pIndex == 0) {
            return null;
        }
        int dX = this.getX(pIndex - 1) - this.getX(pIndex);
        int dY = this.getY(pIndex - 1) - this.getY(pIndex);
        return Direction.fromDelta(dX, dY);
    }

    public Direction getDirectionToNextStep(int pIndex) {
        if (pIndex == this.getLength() - 1) {
            return null;
        }
        int dX = this.getX(pIndex + 1) - this.getX(pIndex);
        int dY = this.getY(pIndex + 1) - this.getY(pIndex);
        return Direction.fromDelta(dX, dY);
    }
}

