/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.algorithm.path.astar;

import org.andengine.util.adt.list.ShiftList;
import org.andengine.util.adt.map.LongSparseArray;
import org.andengine.util.adt.queue.SortedQueue;
import org.andengine.util.adt.spatial.bounds.util.IntBoundsUtils;
import org.andengine.util.algorithm.path.ICostFunction;
import org.andengine.util.algorithm.path.IPathFinder;
import org.andengine.util.algorithm.path.IPathFinderMap;
import org.andengine.util.algorithm.path.Path;
import org.andengine.util.algorithm.path.astar.IAStarHeuristic;

public class AStarPathFinder<T>
implements IPathFinder<T> {
    @Override
    public Path findPath(IPathFinderMap<T> pPathFinderMap, int pXMin, int pYMin, int pXMax, int pYMax, T pEntity, int pFromX, int pFromY, int pToX, int pToY, boolean pAllowDiagonal, IAStarHeuristic<T> pAStarHeuristic, ICostFunction<T> pCostFunction) {
        return this.findPath(pPathFinderMap, pXMin, pYMin, pXMax, pYMax, pEntity, pFromX, pFromY, pToX, pToY, pAllowDiagonal, pAStarHeuristic, pCostFunction, Float.MAX_VALUE);
    }

    @Override
    public Path findPath(IPathFinderMap<T> pPathFinderMap, int pXMin, int pYMin, int pXMax, int pYMax, T pEntity, int pFromX, int pFromY, int pToX, int pToY, boolean pAllowDiagonal, IAStarHeuristic<T> pAStarHeuristic, ICostFunction<T> pCostFunction, float pMaxCost) {
        return this.findPath(pPathFinderMap, pXMin, pYMin, pXMax, pYMax, pEntity, pFromX, pFromY, pToX, pToY, pAllowDiagonal, pAStarHeuristic, pCostFunction, pMaxCost, null);
    }

    @Override
    public Path findPath(IPathFinderMap<T> pPathFinderMap, int pXMin, int pYMin, int pXMax, int pYMax, T pEntity, int pFromX, int pFromY, int pToX, int pToY, boolean pAllowDiagonal, IAStarHeuristic<T> pAStarHeuristic, ICostFunction<T> pCostFunction, float pMaxCost, IPathFinder.IPathFinderListener<T> pPathFinderListener) {
        if (pFromX == pToX && pFromY == pToY || pPathFinderMap.isBlocked(pFromX, pFromY, pEntity) || pPathFinderMap.isBlocked(pToX, pToY, pEntity)) {
            return null;
        }
        Node fromNode = new Node(pFromX, pFromY, pAStarHeuristic.getExpectedRestCost(pPathFinderMap, pEntity, pFromX, pFromY, pToX, pToY));
        long fromNodeID = fromNode.mID;
        long toNodeID = Node.calculateID(pToX, pToY);
        LongSparseArray<Node> visitedNodes = new LongSparseArray<Node>();
        LongSparseArray<Node> openNodes = new LongSparseArray<Node>();
        SortedQueue<Node> sortedOpenNodes = new SortedQueue<Node>(new ShiftList());
        boolean allowDiagonalMovement = pAllowDiagonal;
        openNodes.put(fromNodeID, fromNode);
        sortedOpenNodes.enter(fromNode);
        Node currentNode = null;
        while (openNodes.size() > 0) {
            currentNode = (Node)sortedOpenNodes.poll();
            long currentNodeID = currentNode.mID;
            if (currentNodeID == toNodeID) break;
            visitedNodes.put(currentNodeID, currentNode);
            for (int dX = -1; dX <= 1; ++dX) {
                for (int dY = -1; dY <= 1; ++dY) {
                    boolean neighborNodeIsNew;
                    if (dX == 0 && dY == 0 || !allowDiagonalMovement && dX != 0 && dY != 0) continue;
                    int neighborNodeX = dX + currentNode.mX;
                    int neighborNodeY = dY + currentNode.mY;
                    long neighborNodeID = Node.calculateID(neighborNodeX, neighborNodeY);
                    if (!IntBoundsUtils.contains(pXMin, pYMin, pXMax, pYMax, neighborNodeX, neighborNodeY) || pPathFinderMap.isBlocked(neighborNodeX, neighborNodeY, pEntity) || visitedNodes.indexOfKey(neighborNodeID) >= 0) continue;
                    Node neighborNode = (Node)openNodes.get(neighborNodeID);
                    if (neighborNode == null) {
                        neighborNodeIsNew = true;
                        neighborNode = new Node(neighborNodeX, neighborNodeY, pAStarHeuristic.getExpectedRestCost(pPathFinderMap, pEntity, neighborNodeX, neighborNodeY, pToX, pToY));
                    } else {
                        neighborNodeIsNew = false;
                    }
                    float costFromCurrentToNeigbor = pCostFunction.getCost(pPathFinderMap, currentNode.mX, currentNode.mY, neighborNodeX, neighborNodeY, pEntity);
                    float neighborNodeCost = currentNode.mCost + costFromCurrentToNeigbor;
                    if (neighborNodeCost > pMaxCost) {
                        if (neighborNodeIsNew) continue;
                        openNodes.remove(neighborNodeID);
                        continue;
                    }
                    neighborNode.setParent(currentNode, costFromCurrentToNeigbor);
                    if (neighborNodeIsNew) {
                        openNodes.put(neighborNodeID, neighborNode);
                    } else {
                        sortedOpenNodes.remove(neighborNode);
                    }
                    sortedOpenNodes.enter(neighborNode);
                    if (pPathFinderListener == null) continue;
                    pPathFinderListener.onVisited(pEntity, neighborNodeX, neighborNodeY);
                }
            }
        }
        visitedNodes.clear();
        openNodes.clear();
        sortedOpenNodes.clear();
        if (currentNode.mID != toNodeID) {
            return null;
        }
        int length = 1;
        Node tmp = currentNode;
        while (tmp.mID != fromNodeID) {
            tmp = tmp.mParent;
            ++length;
        }
        Path path = new Path(length);
        int index = length - 1;
        tmp = currentNode;
        while (tmp.mID != fromNodeID) {
            path.set(index, tmp.mX, tmp.mY);
            tmp = tmp.mParent;
            --index;
        }
        path.set(0, pFromX, pFromY);
        return path;
    }

    private static final class Node
    implements Comparable<Node> {
        Node mParent;
        final int mX;
        final int mY;
        final long mID;
        final float mExpectedRestCost;
        float mCost;
        float mTotalCost;

        public Node(int pX, int pY, float pExpectedRestCost) {
            this.mX = pX;
            this.mY = pY;
            this.mExpectedRestCost = pExpectedRestCost;
            this.mID = Node.calculateID(pX, pY);
        }

        public void setParent(Node pParent, float pCost) {
            this.mParent = pParent;
            this.mCost = pCost;
            this.mTotalCost = pCost + this.mExpectedRestCost;
        }

        @Override
        public int compareTo(Node pNode) {
            float diff = this.mTotalCost - pNode.mTotalCost;
            if (diff > 0.0f) {
                return 1;
            }
            if (diff < 0.0f) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther == null) {
                return false;
            }
            if (this.getClass() != pOther.getClass()) {
                return false;
            }
            return this.equals((Node)pOther);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [x=" + this.mX + ", y=" + this.mY + "]";
        }

        public static long calculateID(int pX, int pY) {
            return (long)pX << 32 | (long)pY;
        }

        public boolean equals(Node pNode) {
            return this.mID == pNode.mID;
        }
    }
}

