/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.animationpack;

import android.content.res.AssetManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.util.StreamUtils;
import org.andengine.util.animationpack.AnimationPack;
import org.andengine.util.animationpack.AnimationPackParser;
import org.andengine.util.animationpack.exception.AnimationPackParseException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AnimationPackLoader {
    private final AssetManager mAssetManager;
    private final TextureManager mTextureManager;

    public AnimationPackLoader(AssetManager pAssetManager, TextureManager pTextureManager) {
        this.mAssetManager = pAssetManager;
        this.mTextureManager = pTextureManager;
    }

    public AnimationPack loadFromAsset(String pAssetPath, String pAssetBasePath) throws AnimationPackParseException {
        try {
            return this.load(this.mAssetManager.open(pAssetPath), pAssetBasePath);
        }
        catch (IOException e) {
            throw new AnimationPackParseException("Could not load " + this.getClass().getSimpleName() + " data from asset: " + pAssetPath, e);
        }
    }

    public AnimationPack load(InputStream pInputStream, String pAssetBasePath) throws AnimationPackParseException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            AnimationPackParser animationPackParser = new AnimationPackParser(this.mAssetManager, pAssetBasePath, this.mTextureManager);
            xr.setContentHandler(animationPackParser);
            xr.parse(new InputSource(new BufferedInputStream(pInputStream)));
            AnimationPack animationPack = animationPackParser.getAnimationPack();
            return animationPack;
        }
        catch (SAXException e) {
            throw new AnimationPackParseException(e);
        }
        catch (ParserConfigurationException pe) {
            AnimationPack animationPack = null;
            return animationPack;
        }
        catch (IOException e) {
            throw new AnimationPackParseException(e);
        }
        finally {
            StreamUtils.close(pInputStream);
        }
    }
}

