/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.animationpack;

import android.content.res.AssetManager;
import java.util.ArrayList;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.util.SAXUtils;
import org.andengine.util.adt.list.LongArrayList;
import org.andengine.util.animationpack.AnimationPack;
import org.andengine.util.animationpack.AnimationPackTiledTextureRegion;
import org.andengine.util.animationpack.AnimationPackTiledTextureRegionLibrary;
import org.andengine.util.animationpack.exception.AnimationPackParseException;
import org.andengine.util.texturepack.TexturePack;
import org.andengine.util.texturepack.TexturePackLibrary;
import org.andengine.util.texturepack.TexturePackLoader;
import org.andengine.util.texturepack.TexturePackTextureRegion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnimationPackParser
extends DefaultHandler {
    private static final String TAG_ANIMATIONPACK = "animationpack";
    private static final String TAG_ANIMATIONPACK_ATTRIBUTE_VERSION = "version";
    private static final String TAG_TEXTUREPACKS = "texturepacks";
    private static final String TAG_TEXTUREPACK = "texturepack";
    private static final String TAG_TEXTUREPACK_ATTRIBUTE_FILENAME = "filename";
    private static final String TAG_ANIMATIONS = "animations";
    private static final String TAG_ANIMATION = "animation";
    private static final String TAG_ANIMATION_ATTRIBUTE_NAME = "name";
    private static final String TAG_ANIMATION_ATTRIBUTE_LOOPCOUNT = "loopcount";
    private static final String TAG_ANIMATIONFRAME = "animationframe";
    private static final String TAG_ANIMATIONFRAME_ATTRIBUTE_DURATION = "duration";
    private static final String TAG_ANIMATIONFRAME_ATTRIBUTE_TEXTUREREGION = "textureregion";
    private final AssetManager mAssetManager;
    private final String mAssetBasePath;
    private final TextureManager mTextureManager;
    private AnimationPack mAnimationPack;
    private AnimationPackTiledTextureRegionLibrary mAnimationPackTiledTextureRegionLibrary;
    private TexturePackLibrary mTexturePackLibrary;
    private TexturePackLoader mTexturePackLoader;
    private String mCurrentAnimationName;
    private int mCurrentAnimationLoopCount = -1;
    private final LongArrayList mCurrentAnimationFrameDurations = new LongArrayList();
    private final ArrayList<TexturePackTextureRegion> mCurrentAnimationFrameTexturePackTextureRegions = new ArrayList();

    public AnimationPackParser(AssetManager pAssetManager, String pAssetBasePath, TextureManager pTextureManager) {
        this.mAssetManager = pAssetManager;
        this.mAssetBasePath = pAssetBasePath;
        this.mTextureManager = pTextureManager;
    }

    public AnimationPack getAnimationPack() {
        return this.mAnimationPack;
    }

    @Override
    public void startElement(String pUri, String pLocalName, String pQualifiedName, Attributes pAttributes) throws SAXException {
        if (pLocalName.equals(TAG_ANIMATIONPACK)) {
            int version = SAXUtils.getIntAttributeOrThrow(pAttributes, TAG_ANIMATIONPACK_ATTRIBUTE_VERSION);
            if (version != 1) {
                throw new AnimationPackParseException("Unexpected version: '" + version + "'.");
            }
            this.mTexturePackLoader = new TexturePackLoader(this.mAssetManager, this.mTextureManager);
            this.mTexturePackLibrary = new TexturePackLibrary();
            this.mAnimationPackTiledTextureRegionLibrary = new AnimationPackTiledTextureRegionLibrary();
            this.mAnimationPack = new AnimationPack(this.mTexturePackLibrary, this.mAnimationPackTiledTextureRegionLibrary);
        } else if (!pLocalName.equals(TAG_TEXTUREPACKS)) {
            if (pLocalName.equals(TAG_TEXTUREPACK)) {
                String texturePackName = SAXUtils.getAttributeOrThrow(pAttributes, TAG_TEXTUREPACK_ATTRIBUTE_FILENAME);
                String texturePackPath = this.mAssetBasePath + texturePackName;
                TexturePack texturePack = this.mTexturePackLoader.loadFromAsset(texturePackPath, this.mAssetBasePath);
                this.mTexturePackLibrary.put(texturePackName, texturePack);
                texturePack.loadTexture();
            } else if (!pLocalName.equals(TAG_ANIMATIONS)) {
                if (pLocalName.equals(TAG_ANIMATION)) {
                    this.mCurrentAnimationName = SAXUtils.getAttributeOrThrow(pAttributes, TAG_ANIMATION_ATTRIBUTE_NAME);
                    this.mCurrentAnimationLoopCount = SAXUtils.getIntAttribute(pAttributes, TAG_ANIMATION_ATTRIBUTE_LOOPCOUNT, -1);
                } else if (pLocalName.equals(TAG_ANIMATIONFRAME)) {
                    int duration = SAXUtils.getIntAttributeOrThrow(pAttributes, TAG_ANIMATIONFRAME_ATTRIBUTE_DURATION);
                    this.mCurrentAnimationFrameDurations.add(duration);
                    String textureRegionName = SAXUtils.getAttributeOrThrow(pAttributes, TAG_ANIMATIONFRAME_ATTRIBUTE_TEXTUREREGION);
                    TexturePackTextureRegion texturePackTextureRegion = this.mTexturePackLibrary.getTexturePackTextureRegion(textureRegionName);
                    this.mCurrentAnimationFrameTexturePackTextureRegions.add(texturePackTextureRegion);
                } else {
                    throw new AnimationPackParseException("Unexpected tag: '" + pLocalName + "'.");
                }
            }
        }
    }

    @Override
    public void endElement(String pUri, String pLocalName, String pQualifiedName) throws SAXException {
        if (!(pLocalName.equals(TAG_ANIMATIONPACK) || pLocalName.equals(TAG_TEXTUREPACKS) || pLocalName.equals(TAG_TEXTUREPACK) || pLocalName.equals(TAG_ANIMATIONS))) {
            if (pLocalName.equals(TAG_ANIMATION)) {
                int currentAnimationFrameFrameCount = this.mCurrentAnimationFrameDurations.size();
                long[] frameDurations = this.mCurrentAnimationFrameDurations.toArray();
                ITextureRegion[] textureRegions = new TexturePackTextureRegion[currentAnimationFrameFrameCount];
                this.mCurrentAnimationFrameTexturePackTextureRegions.toArray(textureRegions);
                AnimationPackTiledTextureRegion animationPackTiledTextureRegion = new AnimationPackTiledTextureRegion(this.mCurrentAnimationName, frameDurations, this.mCurrentAnimationLoopCount, textureRegions[0].getTexture(), textureRegions);
                this.mAnimationPackTiledTextureRegionLibrary.put(animationPackTiledTextureRegion);
                this.mCurrentAnimationName = null;
                this.mCurrentAnimationLoopCount = -1;
                this.mCurrentAnimationFrameDurations.clear();
                this.mCurrentAnimationFrameTexturePackTextureRegions.clear();
            } else if (!pLocalName.equals(TAG_ANIMATIONFRAME)) {
                throw new AnimationPackParseException("Unexpected end tag: '" + pLocalName + "'.");
            }
        }
    }
}

