/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.color;

import org.andengine.util.color.Color;

public class ColorUtils {
    private static final float[] HSV_TO_COLOR = new float[3];
    private static final int HSV_TO_COLOR_HUE_INDEX = 0;
    private static final int HSV_TO_COLOR_SATURATION_INDEX = 1;
    private static final int HSV_TO_COLOR_VALUE_INDEX = 2;
    private static final int INT_BITS_TO_FLOAT_MASK = -1;

    public static final int convertHSVToARGBPackedInt(float pHue, float pSaturation, float pValue) {
        ColorUtils.HSV_TO_COLOR[0] = pHue;
        ColorUtils.HSV_TO_COLOR[1] = pSaturation;
        ColorUtils.HSV_TO_COLOR[2] = pValue;
        return android.graphics.Color.HSVToColor((float[])HSV_TO_COLOR);
    }

    public static final Color convertHSVToColor(float pHue, float pSaturation, float pValue) {
        return ColorUtils.convertARGBPackedIntToColor(ColorUtils.convertHSVToARGBPackedInt(pHue, pSaturation, pValue));
    }

    public static Color convertARGBPackedIntToColor(int pARGBPackedInt) {
        float alpha = ColorUtils.extractAlphaFromARGBPackedInt(pARGBPackedInt);
        float red = ColorUtils.extractRedFromARGBPackedInt(pARGBPackedInt);
        float green = ColorUtils.extractGreenFromARGBPackedInt(pARGBPackedInt);
        float blue = ColorUtils.extractBlueFromARGBPackedInt(pARGBPackedInt);
        return new Color(red, green, blue, alpha);
    }

    public static Color convertABGRPackedIntToColor(int pABGRPackedInt) {
        float alpha = ColorUtils.extractAlphaFromABGRPackedInt(pABGRPackedInt);
        float blue = ColorUtils.extractBlueFromABGRPackedInt(pABGRPackedInt);
        float green = ColorUtils.extractGreenFromABGRPackedInt(pABGRPackedInt);
        float red = ColorUtils.extractRedFromABGRPackedInt(pABGRPackedInt);
        return new Color(red, green, blue, alpha);
    }

    public static final int convertRGBAToARGBPackedInt(float pRed, float pGreen, float pBlue, float pAlpha) {
        return (int)(255.0f * pAlpha) << 24 | (int)(255.0f * pRed) << 16 | (int)(255.0f * pGreen) << 8 | (int)(255.0f * pBlue) << 0;
    }

    public static final float convertRGBAToARGBPackedFloat(float pRed, float pGreen, float pBlue, float pAlpha) {
        return ColorUtils.convertPackedIntToPackedFloat(ColorUtils.convertRGBAToARGBPackedInt(pRed, pGreen, pBlue, pAlpha));
    }

    public static final int convertRGBAToABGRPackedInt(float pRed, float pGreen, float pBlue, float pAlpha) {
        return (int)(255.0f * pAlpha) << 24 | (int)(255.0f * pBlue) << 16 | (int)(255.0f * pGreen) << 8 | (int)(255.0f * pRed) << 0;
    }

    public static final float convertRGBAToABGRPackedFloat(float pRed, float pGreen, float pBlue, float pAlpha) {
        return ColorUtils.convertPackedIntToPackedFloat(ColorUtils.convertRGBAToABGRPackedInt(pRed, pGreen, pBlue, pAlpha));
    }

    public static final float convertPackedIntToPackedFloat(int pPackedInt) {
        return Float.intBitsToFloat(pPackedInt & 0xFFFFFFFF);
    }

    public static float extractRedFromABGRPackedInt(int pABGRPackedInt) {
        return (float)(pABGRPackedInt >> 0 & 0xFF) / 255.0f;
    }

    public static float extractGreenFromABGRPackedInt(int pABGRPackedInt) {
        return (float)(pABGRPackedInt >> 8 & 0xFF) / 255.0f;
    }

    public static float extractBlueFromABGRPackedInt(int pABGRPackedInt) {
        return (float)(pABGRPackedInt >> 16 & 0xFF) / 255.0f;
    }

    public static float extractAlphaFromABGRPackedInt(int pABGRPackedInt) {
        return (float)(pABGRPackedInt >> 24 & 0xFF) / 255.0f;
    }

    public static float extractBlueFromARGBPackedInt(int pARGBPackedInt) {
        return (float)(pARGBPackedInt >> 0 & 0xFF) / 255.0f;
    }

    public static float extractGreenFromARGBPackedInt(int pARGBPackedInt) {
        return (float)(pARGBPackedInt >> 8 & 0xFF) / 255.0f;
    }

    public static float extractRedFromARGBPackedInt(int pARGBPackedInt) {
        return (float)(pARGBPackedInt >> 16 & 0xFF) / 255.0f;
    }

    public static float extractAlphaFromARGBPackedInt(int pARGBPackedInt) {
        return (float)(pARGBPackedInt >> 24 & 0xFF) / 255.0f;
    }
}

