/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.debug;

import android.util.Log;

public class Debug {
    private static String sTag = "AndEngine";
    private static String sDebugUser = "";
    private static DebugLevel sDebugLevel = DebugLevel.VERBOSE;

    public static String getTag() {
        return sTag;
    }

    public static void setTag(String pTag) {
        sTag = pTag;
    }

    public static DebugLevel getDebugLevel() {
        return sDebugLevel;
    }

    public static void setDebugLevel(DebugLevel pDebugLevel) {
        if (pDebugLevel == null) {
            throw new IllegalArgumentException("pDebugLevel must not be null!");
        }
        sDebugLevel = pDebugLevel;
    }

    public static void setDebugUser(String pDebugUser) {
        if (pDebugUser == null) {
            throw new IllegalArgumentException("pDebugUser must not be null!");
        }
        sDebugUser = pDebugUser;
    }

    public static void log(DebugLevel pDebugLevel, String pMessage) {
        switch (pDebugLevel) {
            case NONE: {
                return;
            }
            case VERBOSE: {
                Debug.v(pMessage);
                return;
            }
            case INFO: {
                Debug.i(pMessage);
                return;
            }
            case DEBUG: {
                Debug.d(pMessage);
                return;
            }
            case WARNING: {
                Debug.w(pMessage);
                return;
            }
            case ERROR: {
                Debug.e(pMessage);
                return;
            }
        }
    }

    public static void log(DebugLevel pDebugLevel, String pMessage, Throwable pThrowable) {
        switch (pDebugLevel) {
            case NONE: {
                return;
            }
            case VERBOSE: {
                Debug.v(pMessage, pThrowable);
                return;
            }
            case INFO: {
                Debug.i(pMessage, pThrowable);
                return;
            }
            case DEBUG: {
                Debug.d(pMessage, pThrowable);
                return;
            }
            case WARNING: {
                Debug.w(pMessage, pThrowable);
                return;
            }
            case ERROR: {
                Debug.e(pMessage, pThrowable);
                return;
            }
        }
    }

    public static void log(DebugLevel pDebugLevel, String pTag, String pMessage) {
        switch (pDebugLevel) {
            case NONE: {
                return;
            }
            case VERBOSE: {
                Debug.v(pTag, pMessage);
                return;
            }
            case INFO: {
                Debug.i(pTag, pMessage);
                return;
            }
            case DEBUG: {
                Debug.d(pTag, pMessage);
                return;
            }
            case WARNING: {
                Debug.w(pTag, pMessage);
                return;
            }
            case ERROR: {
                Debug.e(pTag, pMessage);
                return;
            }
        }
    }

    public static void log(DebugLevel pDebugLevel, String pTag, String pMessage, Throwable pThrowable) {
        switch (pDebugLevel) {
            case NONE: {
                return;
            }
            case VERBOSE: {
                Debug.v(pTag, pMessage, pThrowable);
                return;
            }
            case INFO: {
                Debug.i(pTag, pMessage, pThrowable);
                return;
            }
            case DEBUG: {
                Debug.d(pTag, pMessage, pThrowable);
                return;
            }
            case WARNING: {
                Debug.w(pTag, pMessage, pThrowable);
                return;
            }
            case ERROR: {
                Debug.e(pTag, pMessage, pThrowable);
                return;
            }
        }
    }

    public static void v(String pMessage) {
        Debug.v(sTag, pMessage, null);
    }

    public static void v(String pMessage, Throwable pThrowable) {
        Debug.v(sTag, pMessage, pThrowable);
    }

    public static void v(String pTag, String pMessage) {
        Debug.v(pTag, pMessage, null);
    }

    public static void v(String pTag, String pMessage, Throwable pThrowable) {
        if (sDebugLevel.isSameOrLessThan(DebugLevel.VERBOSE)) {
            if (pThrowable == null) {
                Log.v((String)pTag, (String)pMessage);
            } else {
                Log.v((String)pTag, (String)pMessage, (Throwable)pThrowable);
            }
        }
    }

    public static void vUser(String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.v(pMessage);
        }
    }

    public static void vUser(String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.v(pMessage, pThrowable);
        }
    }

    public static void vUser(String pTag, String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.v(pTag, pMessage);
        }
    }

    public static void vUser(String pTag, String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.v(pTag, pMessage, pThrowable);
        }
    }

    public static void d(String pMessage) {
        Debug.d(sTag, pMessage, null);
    }

    public static void d(String pMessage, Throwable pThrowable) {
        Debug.d(sTag, pMessage, pThrowable);
    }

    public static void d(String pTag, String pMessage) {
        Debug.d(pTag, pMessage, null);
    }

    public static void d(String pTag, String pMessage, Throwable pThrowable) {
        if (sDebugLevel.isSameOrLessThan(DebugLevel.DEBUG)) {
            if (pThrowable == null) {
                Log.d((String)pTag, (String)pMessage);
            } else {
                Log.d((String)pTag, (String)pMessage, (Throwable)pThrowable);
            }
        }
    }

    public static void dUser(String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.d(pMessage);
        }
    }

    public static void dUser(String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.d(pMessage, pThrowable);
        }
    }

    public static void dUser(String pTag, String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.d(pTag, pMessage);
        }
    }

    public static void dUser(String pTag, String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.d(pTag, pMessage, pThrowable);
        }
    }

    public static void i(String pMessage) {
        Debug.i(sTag, pMessage, null);
    }

    public static void i(String pMessage, Throwable pThrowable) {
        Debug.i(sTag, pMessage, pThrowable);
    }

    public static void i(String pTag, String pMessage) {
        Debug.i(pTag, pMessage, null);
    }

    public static void i(String pTag, String pMessage, Throwable pThrowable) {
        if (sDebugLevel.isSameOrLessThan(DebugLevel.INFO)) {
            if (pThrowable == null) {
                Log.i((String)pTag, (String)pMessage);
            } else {
                Log.i((String)pTag, (String)pMessage, (Throwable)pThrowable);
            }
        }
    }

    public static void iUser(String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.i(pMessage);
        }
    }

    public static void iUser(String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.i(pMessage, pThrowable);
        }
    }

    public static void iUser(String pTag, String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.i(pTag, pMessage);
        }
    }

    public static void iUser(String pTag, String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.i(pTag, pMessage, pThrowable);
        }
    }

    public static void w(String pMessage) {
        Debug.w(sTag, pMessage, null);
    }

    public static void w(Throwable pThrowable) {
        Debug.w("", pThrowable);
    }

    public static void w(String pMessage, Throwable pThrowable) {
        Debug.w(sTag, pMessage, pThrowable);
    }

    public static void w(String pTag, String pMessage) {
        Debug.w(pTag, pMessage, null);
    }

    public static void w(String pTag, String pMessage, Throwable pThrowable) {
        if (sDebugLevel.isSameOrLessThan(DebugLevel.WARNING)) {
            if (pThrowable == null) {
                Log.w((String)pTag, (String)pMessage);
            } else {
                Log.w((String)pTag, (String)pMessage, (Throwable)pThrowable);
            }
        }
    }

    public static void wUser(String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.w(pMessage);
        }
    }

    public static void wUser(Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.w(pThrowable);
        }
    }

    public static void wUser(String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.w(pMessage, pThrowable);
        }
    }

    public static void wUser(String pTag, String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.w(pTag, pMessage);
        }
    }

    public static void wUser(String pTag, String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.w(pTag, pMessage, pThrowable);
        }
    }

    public static void e(String pMessage) {
        Debug.e(sTag, pMessage, null);
    }

    public static void e(Throwable pThrowable) {
        Debug.e(sTag, pThrowable);
    }

    public static void e(String pMessage, Throwable pThrowable) {
        Debug.e(sTag, pMessage, pThrowable);
    }

    public static void e(String pTag, String pMessage) {
        Debug.e(pTag, pMessage, null);
    }

    public static void e(String pTag, String pMessage, Throwable pThrowable) {
        if (sDebugLevel.isSameOrLessThan(DebugLevel.ERROR)) {
            if (pThrowable == null) {
                Log.e((String)pTag, (String)pMessage);
            } else {
                Log.e((String)pTag, (String)pMessage, (Throwable)pThrowable);
            }
        }
    }

    public static void eUser(String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.e(pMessage);
        }
    }

    public static void eUser(Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.e(pThrowable);
        }
    }

    public static void eUser(String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.e(pMessage, pThrowable);
        }
    }

    public static void eUser(String pTag, String pMessage, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.e(pTag, pMessage);
        }
    }

    public static void eUser(String pTag, String pMessage, Throwable pThrowable, String pDebugUser) {
        if (sDebugUser.equals(pDebugUser)) {
            Debug.e(pTag, pMessage, pThrowable);
        }
    }

    public static enum DebugLevel {
        NONE,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        VERBOSE;

        public static DebugLevel ALL;

        public boolean isSameOrLessThan(DebugLevel pDebugLevel) {
            return this.compareTo(pDebugLevel) >= 0;
        }

        static {
            ALL = VERBOSE;
        }
    }
}

