/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.andengine.util.debug.Debug;

public class DebugTimer {
    private static final String SPLIT_STRING = "  Split: ";
    private static final int INDENT_SPACES = "  Split: ".length();
    private final Stack<DebugTime> mDebugTimes = new Stack();
    private final Debug.DebugLevel mDebugLevel;

    public DebugTimer(String pLabel) {
        this(Debug.DebugLevel.DEBUG, pLabel);
    }

    public DebugTimer(Debug.DebugLevel pDebugLevel, String pLabel) {
        this.mDebugLevel = pDebugLevel;
        this.init(pLabel);
    }

    private void init(String pLabel) {
        long now = System.currentTimeMillis();
        DebugTime debugTime = new DebugTime(now, pLabel);
        this.mDebugTimes.add(debugTime);
    }

    public void begin(String pLabel) {
        long now = System.currentTimeMillis();
        DebugTime debugTime = new DebugTime(now, pLabel);
        this.mDebugTimes.peek().begin(debugTime);
        this.mDebugTimes.add(debugTime);
    }

    public void split(String pLabel) {
        this.mDebugTimes.peek().split(pLabel);
    }

    public void end() {
        long now = System.currentTimeMillis();
        if (this.mDebugTimes.size() == 1) {
            throw new IllegalStateException("Cannot end the root of this " + this.getClass().getSimpleName());
        }
        this.mDebugTimes.pop().end(now);
    }

    public void dump() {
        this.dump(false);
    }

    public void dump(boolean pClear) {
        long now = System.currentTimeMillis();
        if (this.mDebugTimes.size() > 1) {
            Debug.w(this.getClass().getSimpleName() + " not all ended!");
        }
        DebugTime root = (DebugTime)this.mDebugTimes.firstElement();
        root.end(now);
        root.dump(0);
        if (pClear) {
            this.clear();
        }
    }

    public void clear() {
        DebugTime root = (DebugTime)this.mDebugTimes.firstElement();
        this.mDebugTimes.clear();
        this.init(root.mLabel);
    }

    public class DebugTime {
        private final long mStartTime;
        private final String mLabel;
        private final boolean mSplit;
        private long mEndTime;
        private ArrayList<DebugTime> mChildren;
        private DebugTime mLastSplit;

        public DebugTime(long pStartTime, String pLabel) {
            this(pStartTime, pLabel, false);
        }

        protected DebugTime(long pStartTime, String pLabel, boolean pSplit) {
            this.mStartTime = pStartTime;
            this.mLabel = pLabel;
            this.mSplit = pSplit;
        }

        public void begin(DebugTime pDebugTime) {
            this.ensureChildrenAllocated();
            this.mChildren.add(pDebugTime);
        }

        public void split(String pLabel) {
            long now = System.currentTimeMillis();
            DebugTime split = this.mLastSplit == null ? new DebugTime(this.mStartTime, pLabel, true) : new DebugTime(this.mLastSplit.mEndTime, pLabel, true);
            split.end(now);
            this.ensureChildrenAllocated();
            this.mChildren.add(split);
            this.mLastSplit = split;
        }

        public void end(long pEndTime) {
            this.mEndTime = pEndTime;
        }

        public void dump(int pIndent) {
            this.dump(pIndent, "");
        }

        public void dump(int pIndent, String pPostfix) {
            if (this.mSplit) {
                char[] indent = new char[(pIndent - 1) * INDENT_SPACES];
                Arrays.fill(indent, ' ');
                Debug.log(DebugTimer.this.mDebugLevel, new String(indent) + DebugTimer.SPLIT_STRING + "'" + this.mLabel + "'" + " @( " + (this.mEndTime - this.mStartTime) + "ms )" + pPostfix);
            } else {
                char[] indent = new char[pIndent * INDENT_SPACES];
                Arrays.fill(indent, ' ');
                if (this.mChildren == null) {
                    Debug.log(DebugTimer.this.mDebugLevel, new String(indent) + "'" + this.mLabel + "' @( " + (this.mEndTime - this.mStartTime) + "ms )" + pPostfix);
                } else {
                    ArrayList<DebugTime> children = this.mChildren;
                    int childCount = children.size();
                    Debug.log(DebugTimer.this.mDebugLevel, new String(indent) + "'" + this.mLabel + "' {");
                    for (int i = 0; i < childCount - 1; ++i) {
                        children.get(i).dump(pIndent + 1, ",");
                    }
                    children.get(childCount - 1).dump(pIndent + 1);
                    Debug.log(DebugTimer.this.mDebugLevel, new String(indent) + "}@( " + (this.mEndTime - this.mStartTime) + "ms )" + pPostfix);
                }
            }
        }

        private void ensureChildrenAllocated() {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
        }
    }
}

