/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.level;

import android.content.res.AssetManager;
import android.content.res.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.andengine.util.StreamUtils;
import org.andengine.util.debug.Debug;
import org.andengine.util.level.IEntityLoader;
import org.andengine.util.level.LevelParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LevelLoader {
    private String mAssetBasePath;
    private IEntityLoader mDefaultEntityLoader;
    private final HashMap<String, IEntityLoader> mEntityLoaders = new HashMap();

    public LevelLoader() {
        this("");
    }

    public LevelLoader(String pAssetBasePath) {
        this.setAssetBasePath(pAssetBasePath);
    }

    public IEntityLoader getDefaultEntityLoader() {
        return this.mDefaultEntityLoader;
    }

    public void setDefaultEntityLoader(IEntityLoader pDefaultEntityLoader) {
        this.mDefaultEntityLoader = pDefaultEntityLoader;
    }

    public void setAssetBasePath(String pAssetBasePath) {
        if (!pAssetBasePath.endsWith("/") && pAssetBasePath.length() != 0) {
            throw new IllegalStateException("pAssetBasePath must end with '/' or be lenght zero.");
        }
        this.mAssetBasePath = pAssetBasePath;
    }

    public String getAssetBasePath() {
        return this.mAssetBasePath;
    }

    protected void onAfterLoadLevel() {
    }

    protected void onBeforeLoadLevel() {
    }

    public void registerEntityLoader(String pEntityName, IEntityLoader pEntityLoader) {
        this.mEntityLoaders.put(pEntityName, pEntityLoader);
    }

    public void registerEntityLoader(String[] pEntityNames, IEntityLoader pEntityLoader) {
        HashMap<String, IEntityLoader> entityLoaders = this.mEntityLoaders;
        for (int i = pEntityNames.length - 1; i >= 0; --i) {
            entityLoaders.put(pEntityNames[i], pEntityLoader);
        }
    }

    public void loadLevelFromAsset(AssetManager pAssetManager, String pAssetPath) throws IOException {
        this.loadLevelFromStream(pAssetManager.open(this.mAssetBasePath + pAssetPath));
    }

    public void loadLevelFromResource(Resources pResources, int pRawResourceID) throws IOException {
        this.loadLevelFromStream(pResources.openRawResource(pRawResourceID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevelFromStream(InputStream pInputStream) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            this.onBeforeLoadLevel();
            LevelParser levelParser = new LevelParser(this.mDefaultEntityLoader, this.mEntityLoaders);
            xr.setContentHandler(levelParser);
            xr.parse(new InputSource(new BufferedInputStream(pInputStream)));
            this.onAfterLoadLevel();
        }
        catch (SAXException se) {
            Debug.e(se);
        }
        catch (ParserConfigurationException pe) {
            Debug.e(pe);
        }
        finally {
            StreamUtils.close(pInputStream);
        }
    }
}

