/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.math;

import java.util.Random;

public final class MathUtils {
    public static final Random RANDOM = new Random(System.nanoTime());

    public static final float atan2(float dY, float dX) {
        return (float)Math.atan2(dY, dX);
    }

    public static final float radToDeg(float pRad) {
        return 57.295776f * pRad;
    }

    public static final float degToRad(float pDegree) {
        return (float)Math.PI / 180 * pDegree;
    }

    public static final int signum(int n) {
        if (n == 0) {
            return 0;
        }
        if (n > 0) {
            return 1;
        }
        return -1;
    }

    public static final int randomSign() {
        if (RANDOM.nextBoolean()) {
            return 1;
        }
        return -1;
    }

    public static final float random(float pMin, float pMax) {
        return pMin + RANDOM.nextFloat() * (pMax - pMin);
    }

    public static final int random(int pMin, int pMax) {
        return pMin + RANDOM.nextInt(pMax - pMin + 1);
    }

    public static final boolean isPowerOfTwo(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public static final int nextPowerOfTwo(float f) {
        return MathUtils.nextPowerOfTwo((int)Math.ceil(f));
    }

    public static final int nextPowerOfTwo(int n) {
        int k = n;
        if (k == 0) {
            return 1;
        }
        --k;
        for (int i = 1; i < 32; i <<= 1) {
            k |= k >> i;
        }
        return k + 1;
    }

    public static final int sum(int[] pValues) {
        int sum = 0;
        for (int i = pValues.length - 1; i >= 0; --i) {
            sum += pValues[i];
        }
        return sum;
    }

    public static final void arraySumInternal(int[] pValues) {
        int valueCount = pValues.length;
        for (int i = 1; i < valueCount; ++i) {
            pValues[i] = pValues[i - 1] + pValues[i];
        }
    }

    public static final void arraySumInternal(long[] pValues) {
        int valueCount = pValues.length;
        for (int i = 1; i < valueCount; ++i) {
            pValues[i] = pValues[i - 1] + pValues[i];
        }
    }

    public static final void arraySumInternal(long[] pValues, long pFactor) {
        pValues[0] = pValues[0] * pFactor;
        int valueCount = pValues.length;
        for (int i = 1; i < valueCount; ++i) {
            pValues[i] = pValues[i - 1] + pValues[i] * pFactor;
        }
    }

    public static final void arraySumInto(long[] pValues, long[] pTargetValues, long pFactor) {
        pTargetValues[0] = pValues[0] * pFactor;
        int valueCount = pValues.length;
        for (int i = 1; i < valueCount; ++i) {
            pTargetValues[i] = pTargetValues[i - 1] + pValues[i] * pFactor;
        }
    }

    public static final float arraySum(float[] pValues) {
        float sum = 0.0f;
        int valueCount = pValues.length;
        for (int i = 0; i < valueCount; ++i) {
            sum += pValues[i];
        }
        return sum;
    }

    public static final float arrayAverage(float[] pValues) {
        return MathUtils.arraySum(pValues) / (float)pValues.length;
    }

    public static float[] rotateAroundCenter(float[] pVertices, float pRotation, float pRotationCenterX, float pRotationCenterY) {
        if (pRotation != 0.0f) {
            float rotationRad = MathUtils.degToRad(pRotation);
            float sinRotationRad = (float)Math.sin(rotationRad);
            float cosRotationInRad = (float)Math.cos(rotationRad);
            for (int i = pVertices.length - 2; i >= 0; i -= 2) {
                float pX = pVertices[i];
                float pY = pVertices[i + 1];
                pVertices[i] = pRotationCenterX + (cosRotationInRad * (pX - pRotationCenterX) - sinRotationRad * (pY - pRotationCenterY));
                pVertices[i + 1] = pRotationCenterY + (sinRotationRad * (pX - pRotationCenterX) + cosRotationInRad * (pY - pRotationCenterY));
            }
        }
        return pVertices;
    }

    public static float[] scaleAroundCenter(float[] pVertices, float pScaleX, float pScaleY, float pScaleCenterX, float pScaleCenterY) {
        if (pScaleX != 1.0f || pScaleY != 1.0f) {
            for (int i = pVertices.length - 2; i >= 0; i -= 2) {
                pVertices[i] = pScaleCenterX + (pVertices[i] - pScaleCenterX) * pScaleX;
                pVertices[i + 1] = pScaleCenterY + (pVertices[i + 1] - pScaleCenterY) * pScaleY;
            }
        }
        return pVertices;
    }

    public static float[] rotateAndScaleAroundCenter(float[] pVertices, float pRotation, float pRotationCenterX, float pRotationCenterY, float pScaleX, float pScaleY, float pScaleCenterX, float pScaleCenterY) {
        MathUtils.rotateAroundCenter(pVertices, pRotation, pRotationCenterX, pRotationCenterY);
        return MathUtils.scaleAroundCenter(pVertices, pScaleX, pScaleY, pScaleCenterX, pScaleCenterY);
    }

    public static float[] revertScaleAroundCenter(float[] pVertices, float pScaleX, float pScaleY, float pScaleCenterX, float pScaleCenterY) {
        return MathUtils.scaleAroundCenter(pVertices, 1.0f / pScaleX, 1.0f / pScaleY, pScaleCenterX, pScaleCenterY);
    }

    public static float[] revertRotateAroundCenter(float[] pVertices, float pRotation, float pRotationCenterX, float pRotationCenterY) {
        return MathUtils.rotateAroundCenter(pVertices, -pRotation, pRotationCenterX, pRotationCenterY);
    }

    public static float[] revertRotateAndScaleAroundCenter(float[] pVertices, float pRotation, float pRotationCenterX, float pRotationCenterY, float pScaleX, float pScaleY, float pScaleCenterX, float pScaleCenterY) {
        MathUtils.revertScaleAroundCenter(pVertices, pScaleX, pScaleY, pScaleCenterX, pScaleCenterY);
        return MathUtils.revertRotateAroundCenter(pVertices, pRotation, pRotationCenterX, pRotationCenterY);
    }

    public static final boolean isInBounds(int pMinValue, int pMaxValue, int pValue) {
        return pValue >= pMinValue && pValue <= pMaxValue;
    }

    public static final boolean isInBounds(float pMinValue, float pMaxValue, float pValue) {
        return pValue >= pMinValue && pValue <= pMaxValue;
    }

    public static final int bringToBounds(int pMinValue, int pMaxValue, int pValue) {
        return Math.max(pMinValue, Math.min(pMaxValue, pValue));
    }

    public static final float bringToBounds(float pMinValue, float pMaxValue, float pValue) {
        return Math.max(pMinValue, Math.min(pMaxValue, pValue));
    }

    public static final float distance(float pX1, float pY1, float pX2, float pY2) {
        float dX = pX2 - pX1;
        float dY = pY2 - pY1;
        return (float)Math.sqrt(dX * dX + dY * dY);
    }

    public static final float length(float pX, float pY) {
        return (float)Math.sqrt(pX * pX + pY * pY);
    }

    public static final float mix(float pX, float pY, float pMix) {
        return pX * (1.0f - pMix) + pY * pMix;
    }

    public static final int mix(int pX, int pY, float pMix) {
        return Math.round((float)pX * (1.0f - pMix) + (float)pY * pMix);
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isOdd(int n) {
        return n % 2 == 1;
    }

    public static float dot(float pXA, float pYA, float pXB, float pYB) {
        return pXA * pXB + pYA * pYB;
    }

    public static float cross(float pXA, float pYA, float pXB, float pYB) {
        return pXA * pYB - pXB * pYA;
    }
}

