/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.util.modifier.BaseModifier;
import org.andengine.util.modifier.IModifier;

public abstract class BaseDurationModifier<T>
extends BaseModifier<T> {
    private float mSecondsElapsed;
    protected float mDuration;

    public BaseDurationModifier(float pDuration) {
        this.mDuration = pDuration;
    }

    public BaseDurationModifier(float pDuration, IModifier.IModifierListener<T> pModifierListener) {
        super(pModifierListener);
        this.mDuration = pDuration;
    }

    protected BaseDurationModifier(BaseDurationModifier<T> pBaseModifier) {
        this(pBaseModifier.mDuration);
    }

    @Override
    public float getSecondsElapsed() {
        return this.mSecondsElapsed;
    }

    @Override
    public float getDuration() {
        return this.mDuration;
    }

    protected abstract void onManagedUpdate(float var1, T var2);

    protected abstract void onManagedInitialize(T var1);

    @Override
    public final float onUpdate(float pSecondsElapsed, T pItem) {
        if (this.mFinished) {
            return 0.0f;
        }
        if (this.mSecondsElapsed == 0.0f) {
            this.onManagedInitialize(pItem);
            this.onModifierStarted(pItem);
        }
        float secondsElapsedUsed = this.mSecondsElapsed + pSecondsElapsed < this.mDuration ? pSecondsElapsed : this.mDuration - this.mSecondsElapsed;
        this.mSecondsElapsed += secondsElapsedUsed;
        this.onManagedUpdate(secondsElapsedUsed, pItem);
        if (this.mDuration != -1.0f && this.mSecondsElapsed >= this.mDuration) {
            this.mSecondsElapsed = this.mDuration;
            this.mFinished = true;
            this.onModifierFinished(pItem);
        }
        return secondsElapsedUsed;
    }

    @Override
    public void reset() {
        this.mFinished = false;
        this.mSecondsElapsed = 0.0f;
    }
}

