/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.util.adt.list.SmartList;
import org.andengine.util.modifier.IModifier;

public abstract class BaseModifier<T>
implements IModifier<T> {
    protected boolean mFinished;
    private boolean mAutoUnregisterWhenFinished = true;
    private final SmartList<IModifier.IModifierListener<T>> mModifierListeners = new SmartList(2);

    public BaseModifier() {
    }

    public BaseModifier(IModifier.IModifierListener<T> pModifierListener) {
        this.addModifierListener(pModifierListener);
    }

    @Override
    public boolean isFinished() {
        return this.mFinished;
    }

    @Override
    public final boolean isAutoUnregisterWhenFinished() {
        return this.mAutoUnregisterWhenFinished;
    }

    @Override
    public final void setAutoUnregisterWhenFinished(boolean pAutoUnregisterWhenFinished) {
        this.mAutoUnregisterWhenFinished = pAutoUnregisterWhenFinished;
    }

    @Override
    public void addModifierListener(IModifier.IModifierListener<T> pModifierListener) {
        if (pModifierListener != null) {
            this.mModifierListeners.add(pModifierListener);
        }
    }

    @Override
    public boolean removeModifierListener(IModifier.IModifierListener<T> pModifierListener) {
        if (pModifierListener == null) {
            return false;
        }
        return this.mModifierListeners.remove(pModifierListener);
    }

    @Override
    public abstract IModifier<T> deepCopy() throws IModifier.DeepCopyNotSupportedException;

    protected void onModifierStarted(T pItem) {
        SmartList<IModifier.IModifierListener<T>> modifierListeners = this.mModifierListeners;
        int modifierListenerCount = modifierListeners.size();
        for (int i = modifierListenerCount - 1; i >= 0; --i) {
            ((IModifier.IModifierListener)modifierListeners.get(i)).onModifierStarted(this, pItem);
        }
    }

    protected void onModifierFinished(T pItem) {
        SmartList<IModifier.IModifierListener<T>> modifierListeners = this.mModifierListeners;
        int modifierListenerCount = modifierListeners.size();
        for (int i = modifierListenerCount - 1; i >= 0; --i) {
            ((IModifier.IModifierListener)modifierListeners.get(i)).onModifierFinished(this, pItem);
        }
    }

    protected static final <T> void assertNoNullModifier(IModifier<T> pModifier) {
        if (pModifier == null) {
            throw new IllegalArgumentException("Illegal 'null' " + IModifier.class.getSimpleName() + " detected!");
        }
    }

    protected static final <T> void assertNoNullModifier(IModifier<T> ... pModifiers) {
        int modifierCount = pModifiers.length;
        for (int i = 0; i < modifierCount; ++i) {
            if (pModifiers[i] != null) continue;
            throw new IllegalArgumentException("Illegal 'null' " + IModifier.class.getSimpleName() + " detected at position: '" + i + "'!");
        }
    }
}

