/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.util.modifier.BaseDurationModifier;
import org.andengine.util.modifier.IModifier;
import org.andengine.util.modifier.ease.EaseLinear;
import org.andengine.util.modifier.ease.IEaseFunction;

public abstract class BaseSingleValueSpanModifier<T>
extends BaseDurationModifier<T> {
    private float mFromValue;
    private float mValueSpan;
    protected final IEaseFunction mEaseFunction;

    public BaseSingleValueSpanModifier(float pDuration, float pFromValue, float pToValue) {
        this(pDuration, pFromValue, pToValue, null, EaseLinear.getInstance());
    }

    public BaseSingleValueSpanModifier(float pDuration, float pFromValue, float pToValue, IEaseFunction pEaseFunction) {
        this(pDuration, pFromValue, pToValue, null, pEaseFunction);
    }

    public BaseSingleValueSpanModifier(float pDuration, float pFromValue, float pToValue, IModifier.IModifierListener<T> pModifierListener) {
        this(pDuration, pFromValue, pToValue, pModifierListener, EaseLinear.getInstance());
    }

    public BaseSingleValueSpanModifier(float pDuration, float pFromValue, float pToValue, IModifier.IModifierListener<T> pModifierListener, IEaseFunction pEaseFunction) {
        super(pDuration, pModifierListener);
        this.mFromValue = pFromValue;
        this.mValueSpan = pToValue - pFromValue;
        this.mEaseFunction = pEaseFunction;
    }

    protected BaseSingleValueSpanModifier(BaseSingleValueSpanModifier<T> pBaseSingleValueSpanModifier) {
        super(pBaseSingleValueSpanModifier);
        this.mFromValue = pBaseSingleValueSpanModifier.mFromValue;
        this.mValueSpan = pBaseSingleValueSpanModifier.mValueSpan;
        this.mEaseFunction = pBaseSingleValueSpanModifier.mEaseFunction;
    }

    public float getFromValue() {
        return this.mFromValue;
    }

    public float getToValue() {
        return this.mFromValue + this.mValueSpan;
    }

    protected abstract void onSetInitialValue(T var1, float var2);

    protected abstract void onSetValue(T var1, float var2, float var3);

    @Override
    protected void onManagedInitialize(T pItem) {
        this.onSetInitialValue(pItem, this.mFromValue);
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed, T pItem) {
        float percentageDone = this.mEaseFunction.getPercentage(this.getSecondsElapsed(), this.mDuration);
        this.onSetValue(pItem, percentageDone, this.mFromValue + percentageDone * this.mValueSpan);
    }

    public void reset(float pDuration, float pFromValue, float pToValue) {
        super.reset();
        this.mDuration = pDuration;
        this.mFromValue = pFromValue;
        this.mValueSpan = pToValue - pFromValue;
    }
}

