/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import java.util.Comparator;
import org.andengine.util.exception.AndEngineRuntimeException;

public interface IModifier<T> {
    public static final Comparator<IModifier<?>> MODIFIER_COMPARATOR_DURATION_DESCENDING = new Comparator<IModifier<?>>(){

        @Override
        public int compare(IModifier<?> pModifierA, IModifier<?> pModifierB) {
            float durationB;
            float durationA = pModifierA.getDuration();
            if (durationA < (durationB = pModifierB.getDuration())) {
                return 1;
            }
            if (durationA > durationB) {
                return -1;
            }
            return 0;
        }
    };

    public void reset();

    public boolean isFinished();

    public boolean isAutoUnregisterWhenFinished();

    public void setAutoUnregisterWhenFinished(boolean var1);

    public IModifier<T> deepCopy() throws DeepCopyNotSupportedException;

    public float getSecondsElapsed();

    public float getDuration();

    public float onUpdate(float var1, T var2);

    public void addModifierListener(IModifierListener<T> var1);

    public boolean removeModifierListener(IModifierListener<T> var1);

    public static class DeepCopyNotSupportedException
    extends AndEngineRuntimeException {
        private static final long serialVersionUID = -5838035434002587320L;
    }

    public static interface IModifierListener<T> {
        public void onModifierStarted(IModifier<T> var1, T var2);

        public void onModifierFinished(IModifier<T> var1, T var2);
    }
}

