/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.util.modifier.BaseModifier;
import org.andengine.util.modifier.IModifier;

public class LoopModifier<T>
extends BaseModifier<T>
implements IModifier.IModifierListener<T> {
    public static final int LOOP_CONTINUOUS = -1;
    private float mSecondsElapsed;
    private final float mDuration;
    private final IModifier<T> mModifier;
    private ILoopModifierListener<T> mLoopModifierListener;
    private final int mLoopCount;
    private int mLoop;
    private boolean mModifierStartedCalled;
    private boolean mFinishedCached;

    public LoopModifier(IModifier<T> pModifier) {
        this(pModifier, -1);
    }

    public LoopModifier(IModifier<T> pModifier, int pLoopCount) {
        this(pModifier, pLoopCount, null, null);
    }

    public LoopModifier(IModifier<T> pModifier, int pLoopCount, IModifier.IModifierListener<T> pModifierListener) {
        this(pModifier, pLoopCount, null, pModifierListener);
    }

    public LoopModifier(IModifier<T> pModifier, int pLoopCount, ILoopModifierListener<T> pLoopModifierListener) {
        this(pModifier, pLoopCount, pLoopModifierListener, null);
    }

    public LoopModifier(IModifier<T> pModifier, int pLoopCount, ILoopModifierListener<T> pLoopModifierListener, IModifier.IModifierListener<T> pModifierListener) {
        super(pModifierListener);
        BaseModifier.assertNoNullModifier(pModifier);
        this.mModifier = pModifier;
        this.mLoopCount = pLoopCount;
        this.mLoopModifierListener = pLoopModifierListener;
        this.mLoop = 0;
        this.mDuration = pLoopCount == -1 ? Float.POSITIVE_INFINITY : pModifier.getDuration() * (float)pLoopCount;
        this.mModifier.addModifierListener(this);
    }

    protected LoopModifier(LoopModifier<T> pLoopModifier) throws IModifier.DeepCopyNotSupportedException {
        this(pLoopModifier.mModifier.deepCopy(), pLoopModifier.mLoopCount);
    }

    @Override
    public LoopModifier<T> deepCopy() throws IModifier.DeepCopyNotSupportedException {
        return new LoopModifier<T>(this);
    }

    public ILoopModifierListener<T> getLoopModifierListener() {
        return this.mLoopModifierListener;
    }

    public void setLoopModifierListener(ILoopModifierListener<T> pLoopModifierListener) {
        this.mLoopModifierListener = pLoopModifierListener;
    }

    @Override
    public float getSecondsElapsed() {
        return this.mSecondsElapsed;
    }

    @Override
    public float getDuration() {
        return this.mDuration;
    }

    @Override
    public float onUpdate(float pSecondsElapsed, T pItem) {
        float secondsElapsedRemaining;
        if (this.mFinished) {
            return 0.0f;
        }
        this.mFinishedCached = false;
        for (secondsElapsedRemaining = pSecondsElapsed; secondsElapsedRemaining > 0.0f && !this.mFinishedCached; secondsElapsedRemaining -= this.mModifier.onUpdate(secondsElapsedRemaining, pItem)) {
        }
        this.mFinishedCached = false;
        float secondsElapsedUsed = pSecondsElapsed - secondsElapsedRemaining;
        this.mSecondsElapsed += secondsElapsedUsed;
        return secondsElapsedUsed;
    }

    @Override
    public void reset() {
        this.mFinished = false;
        this.mLoop = 0;
        this.mSecondsElapsed = 0.0f;
        this.mModifierStartedCalled = false;
        this.mModifier.reset();
    }

    @Override
    public void onModifierStarted(IModifier<T> pModifier, T pItem) {
        if (!this.mModifierStartedCalled) {
            this.mModifierStartedCalled = true;
            this.onModifierStarted(pItem);
        }
        if (this.mLoopModifierListener != null) {
            this.mLoopModifierListener.onLoopStarted(this, this.mLoop, this.mLoopCount);
        }
    }

    @Override
    public void onModifierFinished(IModifier<T> pModifier, T pItem) {
        if (this.mLoopModifierListener != null) {
            this.mLoopModifierListener.onLoopFinished(this, this.mLoop, this.mLoopCount);
        }
        if (this.mLoopCount == -1) {
            this.mSecondsElapsed = 0.0f;
            this.mModifier.reset();
        } else {
            ++this.mLoop;
            if (this.mLoop >= this.mLoopCount) {
                this.mFinished = true;
                this.mFinishedCached = true;
                this.onModifierFinished(pItem);
            } else {
                this.mSecondsElapsed = 0.0f;
                this.mModifier.reset();
            }
        }
    }

    public static interface ILoopModifierListener<T> {
        public void onLoopStarted(LoopModifier<T> var1, int var2, int var3);

        public void onLoopFinished(LoopModifier<T> var1, int var2, int var3);
    }
}

