/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.util.adt.list.SmartList;
import org.andengine.util.modifier.IModifier;

public class ModifierList<T>
extends SmartList<IModifier<T>>
implements IUpdateHandler {
    private static final long serialVersionUID = 1610345592534873475L;
    private final T mTarget;

    public ModifierList(T pTarget) {
        this.mTarget = pTarget;
    }

    public ModifierList(T pTarget, int pCapacity) {
        super(pCapacity);
        this.mTarget = pTarget;
    }

    public T getTarget() {
        return this.mTarget;
    }

    @Override
    public boolean add(IModifier<T> pModifier) {
        if (pModifier == null) {
            throw new IllegalArgumentException("Supplied " + IModifier.class.getSimpleName() + " must not be null.");
        }
        return super.add(pModifier);
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        int modifierCount = this.size();
        if (modifierCount > 0) {
            for (int i = modifierCount - 1; i >= 0; --i) {
                IModifier modifier = (IModifier)this.get(i);
                modifier.onUpdate(pSecondsElapsed, this.mTarget);
                if (!modifier.isFinished() || !modifier.isAutoUnregisterWhenFinished()) continue;
                this.remove(i);
            }
        }
    }

    @Override
    public void reset() {
        for (int i = this.size() - 1; i >= 0; --i) {
            ((IModifier)this.get(i)).reset();
        }
    }
}

