/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import java.util.Arrays;
import org.andengine.util.modifier.BaseModifier;
import org.andengine.util.modifier.IModifier;

public class ParallelModifier<T>
extends BaseModifier<T>
implements IModifier.IModifierListener<T> {
    private float mSecondsElapsed;
    private final float mDuration;
    private final IModifier<T>[] mModifiers;
    private boolean mFinishedCached;

    public ParallelModifier(IModifier<T> ... pModifiers) throws IllegalArgumentException {
        this((IModifier.IModifierListener<T>)null, pModifiers);
    }

    public ParallelModifier(IModifier.IModifierListener<T> pModifierListener, IModifier<T> ... pModifiers) throws IllegalArgumentException {
        super(pModifierListener);
        if (pModifiers.length == 0) {
            throw new IllegalArgumentException("pModifiers must not be empty!");
        }
        BaseModifier.assertNoNullModifier(pModifiers);
        Arrays.sort(pModifiers, MODIFIER_COMPARATOR_DURATION_DESCENDING);
        this.mModifiers = pModifiers;
        IModifier<T> modifierWithLongestDuration = pModifiers[0];
        this.mDuration = modifierWithLongestDuration.getDuration();
        modifierWithLongestDuration.addModifierListener(this);
    }

    protected ParallelModifier(ParallelModifier<T> pParallelModifier) throws IModifier.DeepCopyNotSupportedException {
        IModifier<T>[] otherModifiers = pParallelModifier.mModifiers;
        IModifier<T>[] modifiers = this.mModifiers = new IModifier[otherModifiers.length];
        for (int i = modifiers.length - 1; i >= 0; --i) {
            modifiers[i] = otherModifiers[i].deepCopy();
        }
        IModifier<T> modifierWithLongestDuration = modifiers[0];
        this.mDuration = modifierWithLongestDuration.getDuration();
        modifierWithLongestDuration.addModifierListener(this);
    }

    @Override
    public ParallelModifier<T> deepCopy() throws IModifier.DeepCopyNotSupportedException {
        return new ParallelModifier<T>(this);
    }

    @Override
    public float getSecondsElapsed() {
        return this.mSecondsElapsed;
    }

    @Override
    public float getDuration() {
        return this.mDuration;
    }

    @Override
    public float onUpdate(float pSecondsElapsed, T pItem) {
        float secondsElapsedRemaining;
        float secondsElapsedUsed;
        if (this.mFinished) {
            return 0.0f;
        }
        IModifier<T>[] shapeModifiers = this.mModifiers;
        this.mFinishedCached = false;
        for (secondsElapsedRemaining = pSecondsElapsed; secondsElapsedRemaining > 0.0f && !this.mFinishedCached; secondsElapsedRemaining -= secondsElapsedUsed) {
            secondsElapsedUsed = 0.0f;
            for (int i = shapeModifiers.length - 1; i >= 0; --i) {
                secondsElapsedUsed = Math.max(secondsElapsedUsed, shapeModifiers[i].onUpdate(pSecondsElapsed, pItem));
            }
        }
        this.mFinishedCached = false;
        secondsElapsedUsed = pSecondsElapsed - secondsElapsedRemaining;
        this.mSecondsElapsed += secondsElapsedUsed;
        return secondsElapsedUsed;
    }

    @Override
    public void reset() {
        this.mFinished = false;
        this.mSecondsElapsed = 0.0f;
        IModifier<T>[] shapeModifiers = this.mModifiers;
        for (int i = shapeModifiers.length - 1; i >= 0; --i) {
            shapeModifiers[i].reset();
        }
    }

    @Override
    public void onModifierStarted(IModifier<T> pModifier, T pItem) {
        this.onModifierStarted(pItem);
    }

    @Override
    public void onModifierFinished(IModifier<T> pModifier, T pItem) {
        this.mFinished = true;
        this.mFinishedCached = true;
        this.onModifierFinished(pItem);
    }
}

