/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.modifier;

import org.andengine.util.modifier.BaseModifier;
import org.andengine.util.modifier.IModifier;
import org.andengine.util.modifier.util.ModifierUtils;

public class SequenceModifier<T>
extends BaseModifier<T>
implements IModifier.IModifierListener<T> {
    private ISubSequenceModifierListener<T> mSubSequenceModifierListener;
    private final IModifier<T>[] mSubSequenceModifiers;
    private int mCurrentSubSequenceModifierIndex;
    private float mSecondsElapsed;
    private final float mDuration;
    private boolean mFinishedCached;

    public SequenceModifier(IModifier<T> ... pModifiers) throws IllegalArgumentException {
        this((ISubSequenceModifierListener<T>)null, (IModifier.IModifierListener<T>)null, pModifiers);
    }

    public SequenceModifier(ISubSequenceModifierListener<T> pSubSequenceModifierListener, IModifier<T> ... pModifiers) throws IllegalArgumentException {
        this(pSubSequenceModifierListener, (IModifier.IModifierListener<T>)null, pModifiers);
    }

    public SequenceModifier(IModifier.IModifierListener<T> pModifierListener, IModifier<T> ... pModifiers) throws IllegalArgumentException {
        this(null, pModifierListener, pModifiers);
    }

    public SequenceModifier(ISubSequenceModifierListener<T> pSubSequenceModifierListener, IModifier.IModifierListener<T> pModifierListener, IModifier<T> ... pModifiers) throws IllegalArgumentException {
        super(pModifierListener);
        if (pModifiers.length == 0) {
            throw new IllegalArgumentException("pModifiers must not be empty!");
        }
        BaseModifier.assertNoNullModifier(pModifiers);
        this.mSubSequenceModifierListener = pSubSequenceModifierListener;
        this.mSubSequenceModifiers = pModifiers;
        this.mDuration = ModifierUtils.getSequenceDurationOfModifier(pModifiers);
        pModifiers[0].addModifierListener(this);
    }

    protected SequenceModifier(SequenceModifier<T> pSequenceModifier) throws IModifier.DeepCopyNotSupportedException {
        this.mDuration = pSequenceModifier.mDuration;
        IModifier<T>[] otherModifiers = pSequenceModifier.mSubSequenceModifiers;
        IModifier<T>[] subSequenceModifiers = this.mSubSequenceModifiers = new IModifier[otherModifiers.length];
        for (int i = subSequenceModifiers.length - 1; i >= 0; --i) {
            subSequenceModifiers[i] = otherModifiers[i].deepCopy();
        }
        subSequenceModifiers[0].addModifierListener(this);
    }

    @Override
    public SequenceModifier<T> deepCopy() throws IModifier.DeepCopyNotSupportedException {
        return new SequenceModifier<T>(this);
    }

    public ISubSequenceModifierListener<T> getSubSequenceModifierListener() {
        return this.mSubSequenceModifierListener;
    }

    public void setSubSequenceModifierListener(ISubSequenceModifierListener<T> pSubSequenceModifierListener) {
        this.mSubSequenceModifierListener = pSubSequenceModifierListener;
    }

    @Override
    public float getSecondsElapsed() {
        return this.mSecondsElapsed;
    }

    @Override
    public float getDuration() {
        return this.mDuration;
    }

    @Override
    public float onUpdate(float pSecondsElapsed, T pItem) {
        float secondsElapsedRemaining;
        if (this.mFinished) {
            return 0.0f;
        }
        this.mFinishedCached = false;
        for (secondsElapsedRemaining = pSecondsElapsed; secondsElapsedRemaining > 0.0f && !this.mFinishedCached; secondsElapsedRemaining -= this.mSubSequenceModifiers[this.mCurrentSubSequenceModifierIndex].onUpdate(secondsElapsedRemaining, pItem)) {
        }
        this.mFinishedCached = false;
        float secondsElapsedUsed = pSecondsElapsed - secondsElapsedRemaining;
        this.mSecondsElapsed += secondsElapsedUsed;
        return secondsElapsedUsed;
    }

    @Override
    public void reset() {
        if (this.isFinished()) {
            this.mSubSequenceModifiers[this.mSubSequenceModifiers.length - 1].removeModifierListener(this);
        } else {
            this.mSubSequenceModifiers[this.mCurrentSubSequenceModifierIndex].removeModifierListener(this);
        }
        this.mCurrentSubSequenceModifierIndex = 0;
        this.mFinished = false;
        this.mSecondsElapsed = 0.0f;
        this.mSubSequenceModifiers[0].addModifierListener(this);
        IModifier<T>[] subSequenceModifiers = this.mSubSequenceModifiers;
        for (int i = subSequenceModifiers.length - 1; i >= 0; --i) {
            subSequenceModifiers[i].reset();
        }
    }

    @Override
    public void onModifierStarted(IModifier<T> pModifier, T pItem) {
        if (this.mCurrentSubSequenceModifierIndex == 0) {
            this.onModifierStarted(pItem);
        }
        if (this.mSubSequenceModifierListener != null) {
            this.mSubSequenceModifierListener.onSubSequenceStarted(pModifier, pItem, this.mCurrentSubSequenceModifierIndex);
        }
    }

    @Override
    public void onModifierFinished(IModifier<T> pModifier, T pItem) {
        if (this.mSubSequenceModifierListener != null) {
            this.mSubSequenceModifierListener.onSubSequenceFinished(pModifier, pItem, this.mCurrentSubSequenceModifierIndex);
        }
        pModifier.removeModifierListener(this);
        ++this.mCurrentSubSequenceModifierIndex;
        if (this.mCurrentSubSequenceModifierIndex < this.mSubSequenceModifiers.length) {
            IModifier<T> nextSubSequenceModifier = this.mSubSequenceModifiers[this.mCurrentSubSequenceModifierIndex];
            nextSubSequenceModifier.addModifierListener(this);
        } else {
            this.mFinished = true;
            this.mFinishedCached = true;
            this.onModifierFinished(pItem);
        }
    }

    public static interface ISubSequenceModifierListener<T> {
        public void onSubSequenceStarted(IModifier<T> var1, T var2, int var3);

        public void onSubSequenceFinished(IModifier<T> var1, T var2, int var3);
    }
}

