/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.progress;

import java.util.ArrayList;
import java.util.HashMap;
import org.andengine.util.math.MathUtils;
import org.andengine.util.progress.IProgressListener;

public class ProgressMonitor
implements IProgressListener {
    private final ArrayList<IProgressListener> mProgressListeners = new ArrayList();
    private final HashMap<ProgressMonitor, IProgressListener> mChildProgressMonitorToProgressListenerMap = new HashMap();

    public ProgressMonitor() {
    }

    public ProgressMonitor(IProgressListener pProgressListener) {
        this.mProgressListeners.add(pProgressListener);
    }

    @Override
    public void onProgressChanged(int pProgress) {
        int progressListenerCount = this.mProgressListeners.size();
        for (int i = 0; i < progressListenerCount; ++i) {
            this.mProgressListeners.get(i).onProgressChanged(pProgress);
        }
    }

    public void registerChildProgressMonitor(ProgressMonitor pChildProgressMonitor, final int pChildProgressMonitorRangeFrom, final int pChildProgressMonitorRangeTo) {
        IProgressListener childProgressMonitorListener = new IProgressListener(){

            @Override
            public void onProgressChanged(int pProgress) {
                int progress = MathUtils.mix(pChildProgressMonitorRangeFrom, pChildProgressMonitorRangeTo, (float)pProgress / 100.0f);
                ProgressMonitor.this.onProgressChanged(progress);
            }
        };
        pChildProgressMonitor.addProgressListener(childProgressMonitorListener);
        this.mChildProgressMonitorToProgressListenerMap.put(pChildProgressMonitor, childProgressMonitorListener);
    }

    public void unregisterChildProgressMonitor(ProgressMonitor pChildProgressMonitor) {
        pChildProgressMonitor.removeProgressListener(this.mChildProgressMonitorToProgressListenerMap.get(pChildProgressMonitor));
    }

    private void addProgressListener(IProgressListener pProgressListener) {
        this.mProgressListeners.add(pProgressListener);
    }

    private void removeProgressListener(IProgressListener pProgressListener) {
        this.mProgressListeners.add(pProgressListener);
    }
}

