/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.system;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.andengine.util.StreamUtils;
import org.andengine.util.TextUtils;
import org.andengine.util.debug.Debug;

public class CPUUsage {
    private long mTotal = 0L;
    private long mIdle = 0L;
    private float mUsage = 0.0f;

    public float getUsage() {
        return this.mUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 8192);
            String procStatString = reader.readLine();
            String[] parts = TextUtils.SPLITPATTERN_SPACE.split(procStatString);
            long user = Long.parseLong(parts[2]);
            long nice = Long.parseLong(parts[3]);
            long system = Long.parseLong(parts[4]);
            long idle = Long.parseLong(parts[5]);
            long total = user + nice + system;
            this.mUsage = 100.0f * (float)(total - this.mTotal) / (float)(total - this.mTotal + idle - this.mIdle);
            this.mTotal = total;
            this.mIdle = idle;
            StreamUtils.close(reader);
        }
        catch (IOException e) {
            Debug.e(e);
        }
        finally {
            StreamUtils.close(reader);
        }
    }
}

