/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.system;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.andengine.util.StreamUtils;
import org.andengine.util.debug.Debug;

public class SystemUtils {
    public static final boolean SDK_VERSION_ECLAIR_OR_LATER = Build.VERSION.SDK_INT >= 5;
    public static final boolean SDK_VERSION_FROYO_OR_LATER = Build.VERSION.SDK_INT >= 8;
    public static final boolean SDK_VERSION_GINGERBREAD_OR_LATER = Build.VERSION.SDK_INT >= 9;
    public static final boolean SDK_VERSION_HONEYCOMB_OR_LATER = Build.VERSION.SDK_INT >= 11;
    public static final boolean SDK_VERSION_ICE_CREAM_SANDWICH_OR_LATER = Build.VERSION.SDK_INT >= 14;
    private static final String BOGOMIPS_PATTERN = "BogoMIPS[\\s]*:[\\s]*(\\d+\\.\\d+)[\\s]*\n";
    private static final String MEMTOTAL_PATTERN = "MemTotal[\\s]*:[\\s]*(\\d+)[\\s]*kB\n";
    private static final String MEMFREE_PATTERN = "MemFree[\\s]*:[\\s]*(\\d+)[\\s]*kB\n";

    public static boolean isGoogleTV(Context pContext) {
        return SystemUtils.hasSystemFeature(pContext, "com.google.android.tv");
    }

    public static int getPackageVersionCode(Context pContext) {
        return SystemUtils.getPackageInfo((Context)pContext).versionCode;
    }

    public static String getPackageVersionName(Context pContext) {
        return SystemUtils.getPackageInfo((Context)pContext).versionName;
    }

    public static String getPackageName(Context pContext) {
        return pContext.getPackageName();
    }

    public static String getApkFilePath(Context pContext) throws PackageManager.NameNotFoundException {
        PackageManager packMgmr = pContext.getPackageManager();
        return packMgmr.getApplicationInfo((String)SystemUtils.getPackageName((Context)pContext), (int)0).sourceDir;
    }

    private static PackageInfo getPackageInfo(Context pContext) {
        try {
            return pContext.getPackageManager().getPackageInfo(pContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Debug.e(e);
            return null;
        }
    }

    public static boolean hasSystemFeature(Context pContext, String pFeature) {
        try {
            Method PackageManager_hasSystemFeatures = PackageManager.class.getMethod("hasSystemFeature", String.class);
            return PackageManager_hasSystemFeatures == null ? false : (Boolean)PackageManager_hasSystemFeatures.invoke((Object)pContext.getPackageManager(), pFeature);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isAndroidVersionOrLower(int pBuildVersionCode) {
        return Build.VERSION.SDK_INT <= pBuildVersionCode;
    }

    public static boolean isAndroidVersionOrHigher(int pBuildVersionCode) {
        return Build.VERSION.SDK_INT >= pBuildVersionCode;
    }

    public static boolean isAndroidVersion(int pBuildVersionCodeMin, int pBuildVersionCodeMax) {
        return Build.VERSION.SDK_INT >= pBuildVersionCodeMin && Build.VERSION.SDK_INT <= pBuildVersionCodeMax;
    }

    public static float getCPUBogoMips() throws SystemUtilsException {
        MatchResult matchResult = SystemUtils.matchSystemFile("/proc/cpuinfo", BOGOMIPS_PATTERN, 1000);
        try {
            if (matchResult.groupCount() > 0) {
                return Float.parseFloat(matchResult.group(1));
            }
            throw new SystemUtilsException();
        }
        catch (NumberFormatException e) {
            throw new SystemUtilsException(e);
        }
    }

    public static int getMemoryTotal() throws SystemUtilsException {
        MatchResult matchResult = SystemUtils.matchSystemFile("/proc/meminfo", MEMTOTAL_PATTERN, 1000);
        try {
            if (matchResult.groupCount() > 0) {
                return Integer.parseInt(matchResult.group(1));
            }
            throw new SystemUtilsException();
        }
        catch (NumberFormatException e) {
            throw new SystemUtilsException(e);
        }
    }

    public static int getMemoryFree() throws SystemUtilsException {
        MatchResult matchResult = SystemUtils.matchSystemFile("/proc/meminfo", MEMFREE_PATTERN, 1000);
        try {
            if (matchResult.groupCount() > 0) {
                return Integer.parseInt(matchResult.group(1));
            }
            throw new SystemUtilsException();
        }
        catch (NumberFormatException e) {
            throw new SystemUtilsException(e);
        }
    }

    public static int getCPUFrequencyCurrent() throws SystemUtilsException {
        return SystemUtils.readSystemFileAsInt("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
    }

    public static int getCPUFrequencyMin() throws SystemUtilsException {
        return SystemUtils.readSystemFileAsInt("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq");
    }

    public static int getCPUFrequencyMax() throws SystemUtilsException {
        return SystemUtils.readSystemFileAsInt("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq");
    }

    public static int getCPUFrequencyMinScaling() throws SystemUtilsException {
        return SystemUtils.readSystemFileAsInt("/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
    }

    public static int getCPUFrequencyMaxScaling() throws SystemUtilsException {
        return SystemUtils.readSystemFileAsInt("/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq");
    }

    private static MatchResult matchSystemFile(String pSystemFile, String pPattern, int pHorizon) throws SystemUtilsException {
        InputStream in;
        block5: {
            boolean matchFound;
            in = null;
            Process process = new ProcessBuilder("/system/bin/cat", pSystemFile).start();
            in = process.getInputStream();
            Scanner scanner = new Scanner(in);
            boolean bl = matchFound = scanner.findWithinHorizon(pPattern, pHorizon) != null;
            if (!matchFound) break block5;
            MatchResult matchResult = scanner.match();
            StreamUtils.close(in);
            return matchResult;
        }
        try {
            try {
                throw new SystemUtilsException();
            }
            catch (IOException e) {
                throw new SystemUtilsException(e);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close(in);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readSystemFileAsInt(String pSystemFile) throws SystemUtilsException {
        int n;
        InputStream in = null;
        try {
            Process process = new ProcessBuilder("/system/bin/cat", pSystemFile).start();
            in = process.getInputStream();
            String content = StreamUtils.readFully(in);
            n = Integer.parseInt(content);
        }
        catch (IOException e) {
            try {
                throw new SystemUtilsException(e);
                catch (NumberFormatException e2) {
                    throw new SystemUtilsException(e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
        }
        StreamUtils.close(in);
        return n;
    }

    public static class SystemUtilsException
    extends Exception {
        private static final long serialVersionUID = -7256483361095147596L;

        public SystemUtilsException() {
        }

        public SystemUtilsException(Throwable pThrowable) {
            super(pThrowable);
        }
    }
}

