/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.texturepack;

import android.content.res.AssetManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.util.StreamUtils;
import org.andengine.util.texturepack.TexturePack;
import org.andengine.util.texturepack.TexturePackParser;
import org.andengine.util.texturepack.exception.TexturePackParseException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TexturePackLoader {
    private final AssetManager mAssetManager;
    private final TextureManager mTextureManager;

    public TexturePackLoader(AssetManager pAssetManager, TextureManager pTextureManager) {
        this.mAssetManager = pAssetManager;
        this.mTextureManager = pTextureManager;
    }

    public TexturePack loadFromAsset(String pAssetPath, String pAssetBasePath) throws TexturePackParseException {
        try {
            return this.load(this.mAssetManager.open(pAssetPath), pAssetBasePath);
        }
        catch (IOException e) {
            throw new TexturePackParseException("Could not load " + this.getClass().getSimpleName() + " data from asset: " + pAssetPath, e);
        }
    }

    public TexturePack load(InputStream pInputStream, String pAssetBasePath) throws TexturePackParseException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            TexturePackParser texturePackParser = new TexturePackParser(this.mAssetManager, pAssetBasePath, this.mTextureManager);
            xr.setContentHandler(texturePackParser);
            xr.parse(new InputSource(new BufferedInputStream(pInputStream)));
            TexturePack texturePack = texturePackParser.getTexturePack();
            return texturePack;
        }
        catch (SAXException e) {
            throw new TexturePackParseException(e);
        }
        catch (ParserConfigurationException pe) {
            TexturePack texturePack = null;
            return texturePack;
        }
        catch (IOException e) {
            throw new TexturePackParseException(e);
        }
        finally {
            StreamUtils.close(pInputStream);
        }
    }
}

