/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util.texturepack;

import android.util.SparseArray;
import java.util.HashMap;
import org.andengine.util.texturepack.TexturePackTextureRegion;

public class TexturePackTextureRegionLibrary {
    private final SparseArray<TexturePackTextureRegion> mIDMapping;
    private final HashMap<String, TexturePackTextureRegion> mSourceMapping;

    public TexturePackTextureRegionLibrary(int pInitialCapacity) {
        this.mIDMapping = new SparseArray(pInitialCapacity);
        this.mSourceMapping = new HashMap(pInitialCapacity);
    }

    public SparseArray<TexturePackTextureRegion> getIDMapping() {
        return this.mIDMapping;
    }

    public HashMap<String, TexturePackTextureRegion> getSourceMapping() {
        return this.mSourceMapping;
    }

    public void put(TexturePackTextureRegion pTexturePackTextureRegion) {
        this.throwOnCollision(pTexturePackTextureRegion);
        this.mIDMapping.put(pTexturePackTextureRegion.getID(), (Object)pTexturePackTextureRegion);
        this.mSourceMapping.put(pTexturePackTextureRegion.getSource(), pTexturePackTextureRegion);
    }

    public void remove(int pID) {
        this.mIDMapping.remove(pID);
    }

    public TexturePackTextureRegion get(int pID) {
        return (TexturePackTextureRegion)this.mIDMapping.get(pID);
    }

    public TexturePackTextureRegion get(String pSource) {
        return this.mSourceMapping.get(pSource);
    }

    public TexturePackTextureRegion get(String pSource, boolean pStripExtension) {
        if (pStripExtension) {
            int indexOfExtension = pSource.lastIndexOf(46);
            if (indexOfExtension == -1) {
                return this.get(pSource);
            }
            String stripped = pSource.substring(0, indexOfExtension);
            return this.mSourceMapping.get(stripped);
        }
        return this.get(pSource);
    }

    private void throwOnCollision(TexturePackTextureRegion pTexturePackTextureRegion) throws IllegalArgumentException {
        if (this.mIDMapping.get(pTexturePackTextureRegion.getID()) != null) {
            throw new IllegalArgumentException("Collision with ID: '" + pTexturePackTextureRegion.getID() + "'.");
        }
        if (this.mSourceMapping.get(pTexturePackTextureRegion.getSource()) != null) {
            throw new IllegalArgumentException("Collision with Source: '" + pTexturePackTextureRegion.getSource() + "'.");
        }
    }
}

