/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown.entities;

import android.content.Context;
import eu.codlab.markdown.entities.MarkDownEntity;
import eu.codlab.markdown.raw.ArrayItem;
import eu.codlab.markdown.raw.array.Row;
import eu.codlab.markdown.ui.AutoMeasureAdapter;
import java.util.ArrayList;
import java.util.List;

public class ArrayEntity
extends MarkDownEntity {
    private ArrayItem _array_item;

    private ArrayEntity() {
    }

    public ArrayEntity(ArrayItem array_item) {
        this._array_item = array_item;
    }

    public boolean hasHeader() {
        return this._array_item.getHeader() != null && this._array_item.getHeader().getRow().size() > 0;
    }

    public Row getHeader() {
        return this._array_item.getHeader();
    }

    public List<Row> getRows() {
        return (List)this._array_item.getContent();
    }

    public int getNumberColumns() {
        return this._array_item.getNumberColumns();
    }

    public int getNumberRows() {
        return this._array_item.getNumberRows();
    }

    private boolean addRowToContentForAdapter(List<String> content, Row row) {
        int i;
        if (row == null) {
            return false;
        }
        List<String> columns = row.toColumns();
        for (i = 0; i < columns.size(); ++i) {
            content.add(columns.get(i));
        }
        while (i < this.getNumberColumns()) {
            content.add("");
            ++i;
        }
        return true;
    }

    public AutoMeasureAdapter createAdapter(Context context, int color, int header_color, int body_color, int cell_padding) {
        ArrayList<String> content = new ArrayList<String>();
        List<Row> rows = this.getRows();
        boolean has_header = this.hasHeader();
        if (has_header) {
            Row row = this.getHeader();
            has_header = this.addRowToContentForAdapter(content, row);
        }
        for (Row row : rows) {
            this.addRowToContentForAdapter(content, row);
        }
        return new AutoMeasureAdapter(context, color, content, this.getNumberColumns(), has_header, header_color, body_color, cell_padding);
    }
}

