/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown.raw.array;

import java.util.ArrayList;
import java.util.List;

public class Row {
    private List<String> _calculated_row = null;
    private List<Integer> _column_descriptor;
    private List<String> _lines;

    public Row(List<Integer> column_descriptor) {
        this._column_descriptor = column_descriptor;
        this._lines = new ArrayList<String>();
    }

    public void append(String line) {
        this._lines.add(line);
    }

    public List<String> getRow() {
        return this._lines;
    }

    public String toString() {
        List<String> columns = this.toColumns();
        String result = "lines : " + this._lines.size() + (this._lines.size() > 0 ? " first: " + this._lines.get(0) : " no rows") + "\n calculated :\n";
        int index = 0;
        for (String column : columns) {
            result = result + "column " + index + " : " + column + "\n";
            ++index;
        }
        return result;
    }

    private void appendAtIndex(int index, String string) {
        if (this._calculated_row != null && string != null) {
            while (this._calculated_row.size() <= index) {
                this._calculated_row.add(new String());
            }
            String str = this._calculated_row.get(index);
            if (str == null) {
                str = new String();
            }
            str = str.trim();
            string = string.trim();
            if (str.length() != 0 && string.length() > 0) {
                str = str + " ";
            }
            str = str + string;
            this._calculated_row.set(index, str);
        }
    }

    public List<String> toColumns() {
        if (this._calculated_row == null) {
            this._calculated_row = new ArrayList<String>();
            for (String line : this._lines) {
                int index = 0;
                for (Integer size : this._column_descriptor) {
                    if (line.length() > 0) {
                        int min = Math.min(size, line.length());
                        String current = line.substring(0, min).trim();
                        line = line.substring(min);
                        this.appendAtIndex(index, current);
                    }
                    ++index;
                }
            }
        }
        return this._calculated_row;
    }
}

