/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown.ui;

import android.content.Context;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.List;

public class AutoMeasureAdapter
extends BaseAdapter {
    private Context _context;
    private List<String> _content;
    private int _text_color;
    private int _number_column;
    private boolean _use_header;
    private int _body_color;
    private int _header_color;
    private int _cell_padding;

    private AutoMeasureAdapter() {
    }

    public AutoMeasureAdapter(Context context, int text_color, List<String> content, int number_column, boolean use_header, int header_color, int body_color, int cell_padding) {
        this._context = context;
        this._text_color = text_color;
        this._content = content;
        this._number_column = number_column;
        this._use_header = use_header;
        this._header_color = header_color;
        this._body_color = body_color;
        this._cell_padding = cell_padding;
    }

    public int getCount() {
        return this._content.size();
    }

    private boolean isHeader(int position) {
        return this._use_header && position < this._number_column;
    }

    public String getItem(int position) {
        return this._content.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            TextView textview = new TextView(this._context);
            textview.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
            if (!this._use_header) {
                convertView.setBackgroundColor(this._body_color);
            }
            textview.setPadding(this._cell_padding, this._cell_padding, this._cell_padding, this._cell_padding);
            textview.setClickable(true);
            textview.setLinksClickable(true);
            textview.setMovementMethod(LinkMovementMethod.getInstance());
            textview.setTextColor(this._text_color);
            convertView = textview;
        }
        if (this._use_header) {
            convertView.setBackgroundColor(this.isHeader(position) ? this._header_color : this._body_color);
        }
        ((TextView)convertView).setText((CharSequence)this.getItem(position));
        return convertView;
    }
}

