/*
 * Decompiled with CFR 0.152.
 */
package eu.crydee.syllablecounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SyllableCounter {
    private static final String EXCEPTIONS_PATH = "/eu/crydee/syllablecounter/english-exceptions.txt";
    private static final String SUBSYL_PATH = "/eu/crydee/syllablecounter/english-subsyls.txt";
    private static final String ADDSYL_PATH = "/eu/crydee/syllablecounter/english-addsyls.txt";
    private final Map<String, Integer> exceptions = this.getRessourceLines(this.getClass(), "/eu/crydee/syllablecounter/english-exceptions.txt").filter(line -> !line.isEmpty() && !line.startsWith("#")).map(line -> line.split(" ")).peek(fields -> {
        if (((String[])fields).length != 2) {
            System.err.println("couldn't parse the exceptions file. Didn't find 2 fields in one of the lines.");
        }
    }).collect(Collectors.toMap(fields -> fields[1], fields -> Integer.parseInt(fields[0])));
    private final Set<Pattern> subSyls;
    private final Set<Pattern> addSyls = this.getRessourceLines(this.getClass(), "/eu/crydee/syllablecounter/english-addsyls.txt").filter(line -> !line.isEmpty() && !line.startsWith("#")).map(Pattern::compile).collect(Collectors.toSet());
    private final Set<Character> vowels;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Stream<String> getRessourceLines(Class<?> clazz, String filepath) {
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(filepath), StandardCharsets.UTF_8));){
            Stream<String> stream = fileReader.lines().collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SyllableCounter() {
        this.subSyls = this.getRessourceLines(this.getClass(), SUBSYL_PATH).filter(line -> !line.isEmpty() && !line.startsWith("#")).map(Pattern::compile).collect(Collectors.toSet());
        this.vowels = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'), Character.valueOf('y')));
    }

    public int count(String word) {
        if (word == null) {
            throw new NullPointerException("the word parameter was null.");
        }
        if (word.length() == 0) {
            return 0;
        }
        if (word.length() == 1) {
            return 1;
        }
        String lowerCase = word.toLowerCase(Locale.ENGLISH);
        if (this.exceptions.containsKey(lowerCase)) {
            return this.exceptions.get(lowerCase);
        }
        String prunned = lowerCase.charAt(lowerCase.length() - 1) == 'e' ? lowerCase.substring(0, lowerCase.length() - 1) : lowerCase;
        int count = 0;
        boolean prevIsVowel = false;
        for (char c : prunned.toCharArray()) {
            boolean isVowel = this.vowels.contains(Character.valueOf(c));
            if (isVowel && !prevIsVowel) {
                ++count;
            }
            prevIsVowel = isVowel;
        }
        count = (int)((long)count + this.addSyls.stream().filter(pattern -> pattern.matcher(prunned).find()).count());
        return (count = (int)((long)count - this.subSyls.stream().filter(pattern -> pattern.matcher(prunned).find()).count())) > 0 ? count : 1;
    }
}

