/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.EntityInfo;
import eu.dozd.mongo.MongoMapper;
import eu.dozd.mongo.MongoMapperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

class EntityCodec<T>
implements CollectibleCodec<T> {
    private static final String ID_FIELD = "_id";
    private final Class<T> clazz;
    private final EntityInfo info;
    private final IdGenerator idGenerator;
    private final DocumentCodec documentCodec;
    private final BsonTypeClassMap bsonTypeClassMap;
    private final CodecRegistry registry;
    private final List<Class<?>> ignoredTypes = new LinkedList();
    private final Map<String, Class<?>> typeCache = new HashMap();

    public EntityCodec(Class<T> clazz, EntityInfo info) {
        this.clazz = clazz;
        this.info = info;
        this.idGenerator = (IdGenerator)Assertions.notNull((String)"idGenerator", (Object)new ObjectIdGenerator());
        this.registry = CodecRegistries.fromProviders(MongoMapper.getProviders());
        this.documentCodec = new DocumentCodec(this.registry, new BsonTypeClassMap());
        this.bsonTypeClassMap = new BsonTypeClassMap();
    }

    public T generateIdIfAbsentFromDocument(T t) {
        if (!this.documentHasId(t)) {
            this.info.setId(t, this.idGenerator.generate());
        }
        return t;
    }

    public boolean documentHasId(T t) {
        if (this.info.getIdField() != null) {
            Object id = this.info.getId(t);
            return id != null;
        }
        return false;
    }

    public BsonValue getDocumentId(T t) {
        ObjectId documentId;
        Object id = this.info.getId(t);
        if (id instanceof ObjectId) {
            documentId = (ObjectId)id;
        } else if (id instanceof String) {
            documentId = new ObjectId((String)id);
        } else {
            throw new MongoMapperException("Id can be the type of ObjectId or String.");
        }
        return new BsonObjectId(documentId);
    }

    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        T t;
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            bsonReader.readNull();
            return null;
        }
        Document document = new Document();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = bsonReader.readName();
            if (this.info.isMappedReference(fieldName)) {
                document.put(fieldName, this.registry.get(this.info.getFieldType(fieldName)).decode(bsonReader, decoderContext));
                continue;
            }
            if (this.info.isMap(fieldName)) {
                document.put(fieldName, (Object)this.decodeDocument(bsonReader, decoderContext, this.info.getMapValueType(fieldName)));
                continue;
            }
            if (this.info.isGenericList(fieldName)) {
                document.put(fieldName, this.readGenericList(bsonReader, decoderContext, this.info.getGenericListValueType(fieldName)));
                continue;
            }
            document.put(fieldName, this.readValue(bsonReader, decoderContext, fieldName));
        }
        bsonReader.readEndDocument();
        try {
            t = this.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MongoMapperException("Cannot create instance of class " + this.clazz.getName(), e);
        }
        for (String field : this.info.getFields()) {
            if (field.equals(this.info.getIdField())) {
                this.info.setId(t, document.get((Object)ID_FIELD));
                continue;
            }
            Object o = document.get((Object)field);
            if (this.info.getFieldType(field).isEnum()) {
                o = o == null ? null : Enum.valueOf(this.info.getFieldType(field), (String)o);
            }
            this.info.setValue(t, field, o);
        }
        return t;
    }

    private <V> List<V> readGenericList(BsonReader bsonReader, DecoderContext decoderContext, Class<V> valueClazz) {
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            bsonReader.readNull();
            return null;
        }
        bsonReader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            Codec<V> codec = this.getCodecForType(valueClazz);
            Object decode = codec != null ? codec.decode(bsonReader, decoderContext) : this.readValue(bsonReader, decoderContext, null);
            list.add(decode);
        }
        bsonReader.readEndArray();
        return list;
    }

    public <V> Document decodeDocument(BsonReader bsonReader, DecoderContext decoderContext, Class<V> valueClazz) {
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            bsonReader.readNull();
            return null;
        }
        Document document = new Document();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = bsonReader.readName();
            Codec<V> codec = this.getCodecForType(valueClazz);
            Object decode = codec != null ? codec.decode(bsonReader, decoderContext) : this.readValue(bsonReader, decoderContext, null);
            document.put(fieldName, decode);
        }
        bsonReader.readEndDocument();
        return document;
    }

    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        Document document = new Document();
        for (String field : this.info.getFields()) {
            if (field.equals(this.info.getIdField())) {
                if (!this.documentHasId(t)) continue;
                document.put(ID_FIELD, this.info.getId(t));
                continue;
            }
            if (this.info.getFieldType(field).isEnum()) {
                String value;
                Enum anEnum = (Enum)this.info.getValue(t, field);
                String string = value = anEnum == null ? null : anEnum.name();
                if (value == null && this.info.isNonNull(field)) continue;
                document.put(field, (Object)value);
                continue;
            }
            Object value = this.info.getValue(t, field);
            if (value == null && this.info.isNonNull(field)) continue;
            document.put(field, value);
        }
        this.documentCodec.encode(bsonWriter, document, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext, String fieldName) {
        byte bsonSubType;
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<?> codec = null;
        if (fieldName != null && !fieldName.equals(ID_FIELD) && this.info.hasField(fieldName) && (codec = this.getCodecForType(this.info.getFieldType(fieldName))) != null) {
            return codec.decode(reader, decoderContext);
        }
        if (bsonType == BsonType.ARRAY) {
            return this.readList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && ((bsonSubType = reader.peekBinarySubType()) == BsonBinarySubType.UUID_STANDARD.getValue() || bsonSubType == BsonBinarySubType.UUID_LEGACY.getValue())) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        return this.registry.get(this.bsonTypeClassMap.get(bsonType)).decode(reader, decoderContext);
    }

    private <V> Codec<V> getCodecForType(Class<V> fieldType) {
        if (this.ignoredTypes.contains(fieldType)) {
            return null;
        }
        try {
            return this.registry.get(fieldType);
        }
        catch (MongoMapperException | CodecConfigurationException e) {
            this.ignoredTypes.add(fieldType);
            return null;
        }
    }

    private List<Object> readList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext, null));
        }
        reader.readEndArray();
        return list;
    }
}

