/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.MongoMapperException;
import eu.dozd.mongo.annotation.Entity;
import eu.dozd.mongo.annotation.NonNull;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EntityInfo {
    protected final PropertyDescriptor[] descriptors;
    private final Map<String, PropertyDescriptor> fields = new HashMap<String, PropertyDescriptor>();
    private final String entityName;
    private final Map<String, Class<?>> typeCache = new HashMap();
    private final Class<?> clazz;

    EntityInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.entityName = clazz.getCanonicalName();
        try {
            this.descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.setDescriptors(Arrays.asList(this.descriptors));
    }

    Set<String> getFields() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    String getIdField() {
        return null;
    }

    String getEntityName() {
        return this.entityName;
    }

    boolean isMappedReference(String field) {
        if (!this.fields.containsKey(field)) {
            return false;
        }
        PropertyDescriptor pd = this.getField(field);
        return pd.getPropertyType().isAnnotationPresent(Entity.class);
    }

    boolean isMap(String field) {
        if (!this.fields.containsKey(field)) {
            return false;
        }
        PropertyDescriptor pd = this.getField(field);
        return pd.getPropertyType().equals(Map.class);
    }

    boolean isNonNull(String field) {
        if (!this.fields.containsKey(field)) {
            return false;
        }
        if (this.clazz.isAnnotationPresent(NonNull.class)) {
            return true;
        }
        try {
            if (this.clazz.getDeclaredField(field).isAnnotationPresent(NonNull.class)) {
                return true;
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        PropertyDescriptor pd = this.getField(field);
        return pd.getPropertyType().isAnnotationPresent(NonNull.class);
    }

    boolean isGenericList(String field) {
        if (!this.fields.containsKey(field)) {
            return false;
        }
        PropertyDescriptor pd = this.getField(field);
        if (!pd.getPropertyType().equals(List.class)) {
            return false;
        }
        Type type = pd.getReadMethod().getGenericReturnType();
        return type instanceof ParameterizedType;
    }

    Class<?> getGenericListValueType(String fieldName) {
        if (!this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException("Field " + fieldName + " not found.");
        }
        if (!this.isGenericList(fieldName)) {
            throw new MongoMapperException("Field " + fieldName + " is not a generic list.");
        }
        if (this.typeCache.containsKey(fieldName)) {
            return this.typeCache.get(fieldName);
        }
        PropertyDescriptor pd = this.getField(fieldName);
        Type type = pd.getReadMethod().getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            throw new MongoMapperException("Field " + fieldName + " is not a generic list.");
        }
        ParameterizedType pt = (ParameterizedType)type;
        String className = pt.getActualTypeArguments()[0].getTypeName();
        try {
            Class<?> aClass = Class.forName(className);
            this.typeCache.put(fieldName, aClass);
            return aClass;
        }
        catch (ClassNotFoundException e) {
            throw new MongoMapperException("Class " + className + " not found.");
        }
    }

    Class<?> getMapValueType(String fieldName) {
        if (!this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException("Field " + fieldName + " not found.");
        }
        if (!this.isMap(fieldName)) {
            throw new MongoMapperException("Field " + fieldName + " is not a map.");
        }
        if (this.typeCache.containsKey(fieldName)) {
            return this.typeCache.get(fieldName);
        }
        PropertyDescriptor pd = this.getField(fieldName);
        Type type = pd.getReadMethod().getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            throw new MongoMapperException("Field " + fieldName + " is not a parametrized map with generic type.");
        }
        ParameterizedType pt = (ParameterizedType)type;
        String className = pt.getActualTypeArguments()[1].getTypeName();
        int i = className.indexOf("<");
        if (i > -1) {
            className = className.substring(0, i);
        }
        try {
            Class<?> aClass = Class.forName(className);
            this.typeCache.put(fieldName, aClass);
            return aClass;
        }
        catch (ClassNotFoundException e) {
            throw new MongoMapperException("Class " + className + " not found.");
        }
    }

    Class<?> getFieldType(String field) {
        return this.getField(field).getPropertyType();
    }

    boolean hasField(String field) {
        return this.fields.keySet().contains(field);
    }

    void setValue(Object o, String field, Object v) {
        Method writeMethod = this.getField(field).getWriteMethod();
        if (writeMethod == null) {
            throw new MongoMapperException("Setter for property [" + field + "] in class [" + o.getClass().getCanonicalName() + "] not found.");
        }
        try {
            writeMethod.invoke(o, v);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new MongoMapperException("Cannot set value [" + v + "] for property [" + field + "] in class [" + o.getClass().getCanonicalName() + "].", e);
        }
    }

    Object getValue(Object o, String field) {
        Method readMethod = this.getField(field).getReadMethod();
        try {
            return readMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MongoMapperException("Cannot get value from property [" + field + "] in class [" + o.getClass().getCanonicalName() + "].", e);
        }
    }

    void setId(Object o, Object id) {
    }

    Object getId(Object o) {
        return null;
    }

    private PropertyDescriptor getField(String field) {
        PropertyDescriptor descriptor = this.fields.get(field);
        if (descriptor == null) {
            throw new MongoMapperException("Cannot find definition for property [" + field + "] on class [" + this.getEntityName() + "]. Are you missing getter?");
        }
        return descriptor;
    }

    private void setDescriptors(List<PropertyDescriptor> descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            Boolean tran = (Boolean)descriptor.getValue("transient");
            if (tran != null && tran.booleanValue() || "class".equals(descriptor.getName())) continue;
            this.fields.put(descriptor.getDisplayName(), descriptor);
        }
    }
}

