/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.EntityInfo;
import eu.dozd.mongo.MongoMapperException;
import eu.dozd.mongo.annotation.Id;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.bson.types.ObjectId;

public class EntityInfoWithId
extends EntityInfo {
    private final String idField;
    private final Class<?> idClass;

    EntityInfoWithId(Class<?> clazz) {
        this(clazz, Id.class);
    }

    EntityInfoWithId(Class<?> clazz, Class<?> idClass) {
        super(clazz);
        this.idClass = idClass;
        String idColumn = null;
        block0: for (PropertyDescriptor pd : this.descriptors) {
            Annotation[] declaredAnnotations;
            if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
            for (Annotation annotation : declaredAnnotations = pd.getReadMethod().getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(idClass) && !annotation.annotationType().equals(javax.persistence.Id.class)) continue;
                idColumn = pd.getDisplayName();
                continue block0;
            }
        }
        if (idColumn == null && (idColumn = this.findIdAnnotation(clazz)) == null) {
            throw new MongoMapperException("No ID field defined on class " + clazz.getCanonicalName());
        }
        this.idField = idColumn;
    }

    private String findIdAnnotation(Class<?> klass) {
        for (Field field : klass.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(this.idClass) && !annotation.annotationType().equals(javax.persistence.Id.class)) continue;
                return field.getName();
            }
        }
        return null;
    }

    @Override
    void setId(Object o, Object id) {
        if (this.getFieldType(this.idField).equals(String.class) && id instanceof ObjectId) {
            this.setValue(o, this.idField, id.toString());
        } else {
            this.setValue(o, this.idField, id);
        }
    }

    @Override
    Object getId(Object o) {
        return this.getValue(o, this.idField);
    }

    @Override
    String getIdField() {
        return this.idField;
    }
}

