/*
 * Decompiled with CFR 0.152.
 */
package eu.dozd.mongo;

import eu.dozd.mongo.EntityCodec;
import eu.dozd.mongo.EntityInfo;
import eu.dozd.mongo.EntityInfoWithId;
import eu.dozd.mongo.annotation.Embedded;
import eu.dozd.mongo.annotation.Entity;
import eu.dozd.mongo.annotation.Id;
import java.util.HashMap;
import java.util.Map;
import org.atteo.classindex.ClassIndex;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mongodb.core.mapping.Document;

public class MapperCodecProvider
implements CodecProvider {
    private Map<Class, EntityInfo> entityMap = new HashMap<Class, EntityInfo>();

    public MapperCodecProvider() {
        boolean springOnClasspath;
        EntityInfo info;
        for (Class klass : ClassIndex.getAnnotated(Entity.class)) {
            info = new EntityInfoWithId(klass, Id.class);
            this.entityMap.put(klass, info);
        }
        for (Class klass : ClassIndex.getAnnotated(Embedded.class)) {
            info = new EntityInfo(klass);
            this.entityMap.put(klass, info);
        }
        try {
            Class.forName("org.springframework.data.mongodb.core.mapping.Document", false, this.getClass().getClassLoader());
            Class.forName("org.springframework.data.annotation.Id", false, this.getClass().getClassLoader());
            springOnClasspath = true;
        }
        catch (ClassNotFoundException e) {
            springOnClasspath = false;
        }
        if (springOnClasspath) {
            for (Class klass : ClassIndex.getAnnotated(Document.class)) {
                EntityInfoWithId info2 = new EntityInfoWithId(klass, org.springframework.data.annotation.Id.class);
                this.entityMap.put(klass, info2);
            }
        }
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        EntityInfo info = this.entityMap.get(clazz);
        if (info == null) {
            return null;
        }
        return new EntityCodec<T>(clazz, info);
    }
}

